% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{get_fwcp}
\alias{get_fwcp}
\title{Get the log Frequency Weighted Competitor Probability (FWCP)}
\usage{
get_fwcp(target_freq, competitors_freq, pad = 0, add_target = FALSE)
}
\arguments{
\item{target_freq}{Frequency of target word}

\item{competitors_freq}{Numeric vector containing the frequencies of
competitors (including itself)}

\item{pad}{Value to add to frequencies before taking log; if your
minimum frequency is 0, consider adding a value between 1 and 2;
if your minimum frequency is between 0 and 1, consider adding 1}

\item{add_target}{Boolean; set to TRUE if you want the target
frequency added to the denominator; only do this if the target is
not already included in the competitor set (e.g., if the target
is in the lexicon, it will be captured as its own neighbor, its
own cohort, etc.)}
}
\value{
log FWCP
}
\description{
Get the log Frequency Weighted Competitor Probability (FWCP)
}
\examples{
get_fwcp(100, c(10, 50), pad = 1)
}
