% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complementaryClusters.details.R
\name{complementaryClusters.details}
\alias{complementaryClusters.details}
\title{To explain how and why two clusters are complementary.}
\usage{
complementaryClusters.details(components, cluster1, cluster2)
}
\arguments{
\item{components}{is an elements list. It contains every component that has to be in one cluster or in the other one. But each element can only be included in one cluster.}

\item{cluster1}{is a cluster (matrix).}

\item{cluster2}{is a cluster (matrix).}
}
\value{
Boolean value. Explanation.
}
\description{
To explain how and why two clusters include every element but without repeating anyone.
}
\details{
This function checks if the cluster that will be divided contains the simple elements that they have to include. They have to contain every element, but anyone should be
 duplicated.

The function will return a boolean value.
}
\examples{

data <- c(1,2,1,3,1,4,1,5)

components <- toListDivisive(data)

cluster1 <- matrix(c(1,2,1,3),ncol=2)
cluster2 <- matrix(c(1,4,1,5),ncol=2)
cluster3 <- matrix(c(1,6,1,7),ncol=2)

complementaryClusters.details(components,cluster1,cluster2) #TRUE

complementaryClusters.details(components,cluster3,cluster2) #FALSE

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
