% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cbh_lastdist.R
\name{get_plots_cbh_lastdist}
\alias{get_plots_cbh_lastdist}
\title{Plots the Canopy Base Height (CBH) based on the last distance criterium}
\usage{
get_plots_cbh_lastdist(LAD_profiles, cbh_metrics)
}
\arguments{
\item{LAD_profiles}{Original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function in the \emph{leafR} package).
An object of the class text.}

\item{cbh_metrics}{CBH metrics based on three criteria: maximum LAD percentage, maximum distance and last distance.
(output of [get_cbh_metrics()] function).
An object of the class text.}
}
\value{
A plot drawing the Canopy Base Height (CBH) of the fuel layer located at the last distance.
}
\description{
This function plots the CBH of a segmented tree based on the fuel layer located at the last distance.
}
\examples{
library(ggplot2)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

# Before running this example, make sure to run get_cbh_metrics().
if (interactive()) {
cbh_metrics <- get_cbh_metrics()
LadderFuelsR::cbh_metrics$treeID <- factor(LadderFuelsR::cbh_metrics$treeID)

trees_name1 <- as.character(cbh_metrics$treeID)
trees_name2 <- factor(unique(trees_name1))

# Generate plots for CBH based on the fuel layer at the last distance
plots_cbh_lastdist <- get_plots_cbh_lastdist(LAD_profiles, cbh_metrics)
}
}
\seealso{
\code{\link{get_cbh_metrics}}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
