% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrected_distances.R
\name{get_effective_gap}
\alias{get_effective_gap}
\title{Effective Distances and CBHs based on maximum and last distance}
\usage{
get_effective_gap(effective_depth, verbose=TRUE)
}
\arguments{
\item{effective_depth}{Tree metrics with the recalculated depth values considering distances > 1 m (output of [get_real_depths()] function).
An object of the class data frame.}

\item{verbose}{Logical, indicating whether to display informational messages (default is TRUE).}
}
\value{
A data frame giving the effective distances (> 1 m) between consecutive fuel layers, identifying the Canopy Base Height (CBH) of the fuel layer
at the maximum distance and at the last distance.
}
\description{
This function recalculates the distance between fuel layers after removing distances = 1 m and determines the CBH based on the fuel layers
with the highest and the last distance.
}
\details{
List of tree metrics:
\itemize{
  \item treeID: tree ID with strings and numeric values
  \item treeID1: tree ID with only numeric values
  \item dist: Distance between consecutive fuel layers (m)
  \item Hdist: Height of the distance between consecutive fuel layers (m)
  \item Hcbh: Height of the base of each fuel layer (m)
  \item effdist: Effective distance between consecutive fuel layers (m) (> 1 m)
  \item dptf: Depth of fuel layers (m) after removing distances equal to 1 m
  \item Hdptf: Height of the depth of fuel layers (m) after removing distances equal to 1 m
  \item max_Hcbh: Canopy base height of the segmented tree based on the maximum distance found in its profile
  \item last_Hcbh: Canopy base height of the segmented tree based on the last distance found in its profile
  \item max_height: Maximum height of the tree profile
  \item max_: Values of distance and fuel depth and their corresponding heights at the maximum distance found in the tree profile
  \item last_: Values of distance and fuel depth and their corresponding heights at the last distance found in its profile
}
}
\examples{
library(magrittr)
library(stringr)
library(dplyr)

# Before running this example, make sure to run get_real_depths().
if (interactive()) {
effective_depth <- get_real_depths()
LadderFuelsR::effective_depth$treeID <- factor(LadderFuelsR::effective_depth$treeID)

trees_name1 <- as.character(effective_depth$treeID)
trees_name2 <- factor(unique(trees_name1))

corr_distance_metrics_list <- list()

for (i in levels(trees_name2)) {
tree1 <- effective_depth |> dplyr::filter(treeID == i)
corr_distance_metrics <- get_effective_gap(tree1, verbose=TRUE)
corr_distance_metrics_list[[i]] <- corr_distance_metrics
}

# Combine the individual data frames
effective_distances <- dplyr::bind_rows(corr_distance_metrics_list)
}
}
\seealso{
\code{\link{get_real_depths}}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
