% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_chisq_test_simulate.R
\name{power.chisq.test.simulate}
\alias{power.chisq.test.simulate}
\title{Simulate power of Chi-squared tests with conditioning}
\usage{
power.chisq.test.simulate(
  x,
  conditioning = "total",
  x0 = NULL,
  sig.level = 0.05,
  B = 10000
)
}
\arguments{
\item{x}{matrix specifying the alternative distribution of the contingency table.}

\item{conditioning}{character string specifying the simulation scenario. Defaults to \code{"total"}. Other possible scenarios are \code{"row"}, \code{"col"}, and \code{"both"}.}

\item{x0}{matrix specifying the null distribution. Defaults to \code{NULL}, in which case the null is estimated from the alternative \code{x}.}

\item{sig.level}{significance level used in test. Defaults to 0.05.}

\item{B}{integer specifying the number of replicates used in the Monte Carlo test. Defaults to 10000.}
}
\value{
An object of class \code{"power.htest"}.
}
\description{
\code{power.chisq.test.simulate} simulates power for tests for 2-way contingency tables based on the Pearson Chi-squared test statistics by simulation under 4 different conditioning scenarios.
}
\details{
Using \code{conditioning="both"} corresponds to selecting \code{simulate.p.value=TRUE} in \code{\link{chisq.test}}. However, conditioning on both row and column marginals appears to be rarely justified in real data. Instead \code{conditioning="total"} is the correct choice for testing independence. Similarly, \code{conditioning="row"} is recommended when the row marginals e.g. are fixed by experimental design.
Both the alternative and the null are simulated under the parametric scenario estimated from the data matrix \code{x}. This possibly induces a discrepancy with \code{\link{chisq.test.simulate}}, where the null also is simulated from the specific data instance. Thus, the problem is that the null distribution depends on the model parameters.
}
\note{
The code has not been optimized for speed, and might be slow.
}
\examples{
# The Avadex dataset
Xobs <- matrix(c(2,3,6,40),2,2)
rownames(Xobs) <- c("Avadex +","Avadex -")
colnames(Xobs) <- c("Tumor +","Tumor -")

# In this example only the rows appear to be fixed by experimental design.
power.chisq.test.simulate(Xobs,"row")
power.chisq.test.simulate(Xobs,"total")

}
\seealso{
\code{\link{chisq.test.simulate}}
}
\author{
Bo Markussen
}
\keyword{htest}
