% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_R_SQUARED.R
\name{r.squared}
\alias{r.squared}
\title{Coefficient of determination}
\usage{
r.squared(db, target)
}
\arguments{
\item{db}{Data frame of risk factors and target variable supplied for bivariate analysis.}

\item{target}{Name of target variable within \code{db} argument.}
}
\value{
The command \code{r.squared} returns the data frames with a following statistics:
name of the processed risk factor (\code{rf}), type of processed risk factor (\code{rf.type}),
number of missing and infinite observations (\code{miss.inf}), percentage of missing and
infinite observations (\code{miss.inf.pct}), coefficient of determination (\code{r.squared})
}
\description{
\code{r.squared} returns coefficient of determination for risk factors
supplied in data frame \code{db}. Implemented algorithm processes numerical as well
as categorical risk factor. \cr
Usually, this procedure is applied as starting point of bivariate analysis in LGD model development.
}
\examples{
library(monobin)
library(LGDtoolkit)
data(lgd.ds.c)
r.squared(db = lgd.ds.c, target = "lgd")
#add categorical risk factor
lgd.ds.c$rf_03_bin <- sts.bin(x = lgd.ds.c$rf_03, y = lgd.ds.c$lgd)[[2]]
r.squared(db = lgd.ds.c, target = "lgd")
#add risk factor with all missing, only one complete case and zero variance risk factor
lgd.ds.c$rf_20 <- NA
lgd.ds.c$rf_21 <- c(1, rep(NA, nrow(lgd.ds.c) - 1))
lgd.ds.c$rf_22 <- c(c(1, 1), rep(NA, nrow(lgd.ds.c) - 2))
r.squared(db = lgd.ds.c, target = "lgd")
}
