% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDtrait.R
\name{LDtrait}
\alias{LDtrait}
\title{Determine if genomic variants are associated with a trait or disease.}
\usage{
LDtrait(
  snps,
  pop = "CEU",
  r2d = "r2",
  r2d_threshold = 0.1,
  win_size = 5e+05,
  token = NULL,
  file = FALSE,
  genome_build = "grch37",
  api_root = "https://ldlink.nih.gov/LDlinkRest"
)
}
\arguments{
\item{snps}{between 1 - 50 variants, using an rsID or chromosome coordinate (e.g. "chr7:24966446").
All input variants must match a bi-allelic variant.}

\item{pop}{a 1000 Genomes Project population, (e.g. YRI or CEU), multiple allowed, default = "CEU".
Use the `list_pop` function to see a list of available human reference populations.}

\item{r2d}{use "r2" to filter desired output from a threshold based on estimated
LD R2 (R squared) or "d" for LD D' (D-prime), default = "r2".}

\item{r2d_threshold}{R2 or D' (depends on 'r2d' user input parameter) threshold for LD filtering. Any variants
within -/+ of the specified genomic window and R^2 or D' less than the threshold will be removed. Value needs
to be in the range 0 to 1. Default value is 0.1.}

\item{win_size}{set genomic window size for LD calculation. Specify a value greater than or equal to zero and less than or
equal to 1,000,000bp. Default value is -/+ 500,000 bp.}

\item{token}{LDlink provided user token, default = NULL, register for token at \url{https://ldlink.nih.gov/?tab=apiaccess}}

\item{file}{Optional character string naming a path and file for saving results.  If file = FALSE, no file will be generated, default = FALSE.}

\item{genome_build}{Choose between one of the three options...`grch37` for genome build GRCh37 (hg19),
`grch38` for GRCh38 (hg38), or `grch38_high_coverage` for GRCh38 High Coverage (hg38) 1000 Genome Project
data sets.  Default is GRCh37 (hg19).}

\item{api_root}{Optional alternative root url for API.}
}
\value{
A data frame of all query variant RS numbers with a list of queried variants
in LD with a variant reported in the GWAS Catalog (\url{https://www.ebi.ac.uk/gwas/docs/file-downloads}.
}
\description{
Search if a list of variants (or variants in LD with those variants) have been
previously associated with a trait or disease. Trait and disease data is updated
nightly from the GWAS Catalog (\url{https://www.ebi.ac.uk/gwas/docs/file-downloads}.
}
\examples{
\dontrun{LDtrait(snps = "rs456",
                 pop = c("YRI", "CEU"),
                 r2d = "r2",
                 r2d_threshold = "0.1",
                 win_size = "500000",
                 token = Sys.getenv("LDLINK_TOKEN")
                )
         }

}
