% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsK.R
\name{plotTGVrncToLDL}
\alias{plotTGVrncToLDL}
\title{Plots LDL variance versus increasing triglyceride variance}
\usage{
plotTGVrncToLDL(dfTGVars, LDLTGVrncErrProp, LDLTGVrncBoot)
}
\arguments{
\item{dfTGVars}{A data frame with increasing variances of triglycerides.}

\item{LDLTGVrncErrProp}{A vector with the error propagation variances of LDL when the
triglyceride variance increases.}

\item{LDLTGVrncBoot}{A vector with the bootstrap variances of LDL when the
triglycerides variance increases.}
}
\value{
The function creates a plot with the LDL error propagation and
bootstrap variances versus increasing  triglyceride variances.
}
\description{
Plots the variance of LDL (both Error Propagation and Bootstrap variance)
versus increasing triglyceride variance.
}
\examples{
\donttest{
## For LDL - TG:
# Make the DF of ascending variances for TG of sample
TGVariances = CV_Range(sampleA$TG,15,16,plot=FALSE)
# Get the Error Propagation and the Bootstrap variance of LDL relative to TG
LDLTGSampleDependance = LDL_TGVrnc(TGVariances,sampleA$CHOL, sampleA$HDL, bootStrpReps =2000)
plotTGVrncToLDL(TGVariances,LDLTGSampleDependance$ErrPropVrnc,LDLTGSampleDependance$BootVrnc)
}
}
