% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIP.R
\name{AIPErrPrp2Ord}
\alias{AIPErrPrp2Ord}
\title{Second Order Taylor expansion AIP Error propagation variance}
\usage{
AIPErrPrp2Ord(TG, HDL, SI=TRUE, roundDigit=5)
}
\arguments{
\item{TG}{A vector or data frame column containing the triglyceride (TG) values to be used for
the calculation of the variance of the Atherogenic Index of Plasma (AIP)
using second order Taylor expansion. TG and HDL must be of the same length.}

\item{HDL}{A vector or data frame column containing the high density lipoprotein (HDL) values
to be used for the calculation of the variance of the Atherogenic Index of Plasma (AIP)
using second order Taylor expansion.
TG and HDL must be of the same length.}

\item{SI}{Boolean (default=TRUE). AIP is by definition calculated using SI units for TG and HDL
(mmol/L). If mg/dl units are provided instead, SI must be set to FALSE.}

\item{roundDigit}{Decimal digits to round the result to (default = 5).}
}
\value{
The variance of AIP using error propagation theory.
}
\description{
Calculate the second order Taylor Expansion error propagation
(delta method) variance of the Atherogenic Index of Plasma.
}
\examples{
\dontrun{
AIPpropagationVarTaylor = AIPErrPrp2Ord(sampleA$TG,sampleA$HDL)
}
}
\references{
Casella G, Berger RL. Statistical Inference. 2nd ed.
Duxbury Thomson Learning 2002, Pages 240-245

Joint Commitee for Guides in Metrology. Evaluation of measurement data-
Guide to the expression of uncertainty in measurement. 2008.

Joint Commitee for Guides in Metrology. International Vocabulary of Metrology (VIM)-
Basic and General Concepts and Associated Terms. 2012.
}
