% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.R
\name{prep_pbar}
\alias{prep_pbar}
\alias{update_pbar}
\title{Initialize and tick through the progress bar}
\usage{
prep_pbar(control = list(), bar_type = "rho", nr = NULL)

update_pbar(pbar, control = list())
}
\arguments{
\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}. Of use here is \code{quiet} which is a
a \code{logical} indicator of whether there should be information 
(i.e. the progress bar) printed during the run or not. Default is 
\code{TRUE}.}

\item{bar_type}{"rho" (for change point locations) or "eta" (for 
regressors).}

\item{nr}{\code{integer} number of unique realizations, needed when
\code{bar_type} = "eta".}

\item{pbar}{The progress bar object returned from \code{prep_pbar}.}
}
\value{
\code{prep_pbar}: the initialized progress bar object. \cr \cr
  \code{update_pbar}: the ticked-forward \code{pbar}.
}
\description{
\code{prep_pbar} creates and \code{update_pbar} steps
  through the progress bars (if desired) in \code{\link{TS}}
}
\examples{
  pb <- prep_pbar(control = list(nit = 2)); pb
  pb <- update_pbar(pb); pb
  pb <- update_pbar(pb); pb

}
