% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_athena.R
\name{fit_athena}
\alias{fit_athena}
\title{Porting of 'ATHENA' linear combination fitting}
\usage{
fit_athena(all.samples, all.standards, LC.vals, amoSTD, ex.smaller = NULL,
  file.output = NULL, best.fits = NULL)
}
\arguments{
\item{all.samples}{List of all samples}

\item{all.standards}{List of all standards}

\item{LC.vals}{The fitting range values for the linear combination fitting}

\item{amoSTD}{Use at most X standards}

\item{ex.smaller}{Exclude portions smaller than a given value (decimal form), default to NULL}

\item{file.output}{Possibility to have a file output, default to NULL}

\item{best.fits}{Possibility to output more than the best fit (e.g. the first 10 best fits), default to 1}
}
\description{
The function can be used to check which combinations of standards produce a good fit and if output from 'ATHENA' is similar.
}
\examples{
data(stdmix)
corr.spec.standards  <- initial_load(specdat[1:4], 
  corr.norm = c(-36, -15, 37, 58))
corr.spec.samples    <- initial_load(specdat[5:8], 
  corr.norm = c(-36, -15, 37, 58))
athena.fit <- fit_athena(all.samples = corr.spec.samples, 
  all.standards = corr.spec.standards, LC.vals = c(-14, 46), amoSTD = 4)
## exclude portions smaller 5\% = 0.05
athena.fit.exlcude <- fit_athena(all.samples = corr.spec.samples, 
  all.standards = corr.spec.standards, 
  LC.vals = c(-14, 46), amoSTD = 4, ex.smaller = 0.05)
}
\keyword{correction}
\keyword{normalization}
