/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.lucene.analysis.kr.TrieEdge;
import org.apache.lucene.analysis.kr.TrieNode;
import org.apache.lucene.analysis.kr.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trie<S, V> {
    private TrieNode<V> root;
    private boolean ignoreCase;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public Trie(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    public String canonicalCase(String s) {
        if (!this.ignoreCase) {
            return s;
        }
        return s.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    private final int match(String a, int startOffset, int stopOffset, String b) {
        int i = startOffset;
        int j = 0;
        while (j < b.length()) {
            if (i >= stopOffset) {
                return j;
            }
            if (a.charAt(i) != b.charAt(j)) {
                return j;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    public V add(String key, V value) {
        key = this.canonicalCase(key);
        TrieNode<V> node = this.root;
        int i = 0;
        while (i < key.length()) {
            TrieEdge<V> edge = node.get(key.charAt(i));
            if (edge == null) {
                TrieNode<V> newNode = new TrieNode<V>(value);
                node.put(key.substring(i), newNode);
                return null;
            }
            String label = edge.getLabel();
            int j = this.match(key, i, key.length(), label);
            if (j >= 0) {
                TrieNode<V> child = edge.getChild();
                TrieNode<V> intermediate = new TrieNode<V>();
                String a = label.substring(0, j);
                String b = label.substring(j);
                String c = key.substring(i + j);
                if (c.length() > 0) {
                    TrieNode<V> newNode = new TrieNode<V>(value);
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.put(c, newNode);
                } else {
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.setValue(value);
                }
                return null;
            }
            node = edge.getChild();
            i += label.length();
        }
        V ret = node.getValue();
        node.setValue(value);
        return ret;
    }

    private TrieNode<V> fetch(String prefix) {
        TrieNode<V> node = this.root;
        int i = 0;
        while (i < prefix.length()) {
            TrieEdge<V> edge = node.get(prefix.charAt(i));
            if (edge == null) {
                return null;
            }
            String label = edge.getLabel();
            int j = this.match(prefix, i, prefix.length(), label);
            if (j != -1) {
                return null;
            }
            i += label.length();
            node = edge.getChild();
        }
        return node;
    }

    public Object get(String key) {
        TrieNode<V> node = this.fetch(key = this.canonicalCase(key));
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public boolean remove(String key) {
        TrieNode<V> node = this.fetch(key = this.canonicalCase(key));
        if (node == null) {
            return false;
        }
        boolean ret = node.getValue() != null;
        node.setValue(null);
        return ret;
    }

    public Iterator getPrefixedBy(String prefix) {
        prefix = this.canonicalCase(prefix);
        return this.getPrefixedBy(prefix, 0, prefix.length());
    }

    public Iterator getPrefixedBy(String prefix, int startOffset, int stopOffset) {
        TrieNode<V> node = this.root;
        int i = startOffset;
        while (i < stopOffset) {
            TrieEdge<V> edge = node.get(prefix.charAt(i));
            if (edge == null) {
                return EMPTY_ITERATOR;
            }
            node = edge.getChild();
            String label = edge.getLabel();
            int j = this.match(prefix, i, stopOffset, label);
            if (i + j == stopOffset) break;
            if (j >= 0) {
                node = null;
                break;
            }
            i += label.length();
        }
        if (node == null) {
            return EMPTY_ITERATOR;
        }
        return new ValueIterator(node);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<root>");
        this.toStringHelper(this.root, buf, 1);
        return buf.toString();
    }

    private void toStringHelper(TrieNode start, StringBuffer buf, int indent) {
        if (start.getValue() != null) {
            buf.append(" -> ");
            buf.append(start.getValue().toString());
        }
        buf.append("\n");
        Iterator iter = start.labelsForward();
        while (iter.hasNext()) {
            int i = 0;
            while (i < indent) {
                buf.append(" ");
                ++i;
            }
            String label = (String)iter.next();
            buf.append(label);
            TrieNode child = start.get(label.charAt(0)).getChild();
            this.toStringHelper(child, buf, indent + 1);
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
        }
    }

    public class NodeIterator
    extends UnmodifiableIterator {
        private ArrayList stack = new ArrayList();
        private boolean withNulls;

        public NodeIterator(TrieNode start, boolean withNulls) {
            this.withNulls = withNulls;
            if (withNulls || start.getValue() != null) {
                this.stack.add(start);
            } else {
                this.advance(start);
            }
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            int size = this.stack.size();
            if (size == 0) {
                throw new NoSuchElementException();
            }
            TrieNode node = (TrieNode)this.stack.remove(size - 1);
            this.advance(node);
            return node;
        }

        private void advance(TrieNode node) {
            Iterator children = node.childrenForward();
            while (true) {
                if (children.hasNext()) {
                    node = (TrieNode)children.next();
                    if (children.hasNext()) {
                        this.stack.add(children);
                    }
                    if (this.withNulls || node.getValue() == null) {
                        children = node.childrenForward();
                        continue;
                    }
                    this.stack.add(node);
                    return;
                }
                int size = this.stack.size();
                if (size == 0) {
                    return;
                }
                children = (Iterator)this.stack.remove(size - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends NodeIterator {
        ValueIterator(TrieNode start) {
            super(start, false);
        }

        @Override
        public Object next() {
            return ((TrieNode)super.next()).getValue();
        }
    }
}

