/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.analysis.kr.utils.TrieEdge;
import org.apache.lucene.analysis.kr.utils.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TrieNode<V> {
    private V value = null;
    private ArrayList<TrieEdge<V>> children = new ArrayList(0);

    public TrieNode() {
    }

    public TrieNode(V value) {
        this.value = value;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    private final TrieEdge<V> get(int i) {
        return this.children.get(i);
    }

    private final int search(char c, boolean exact) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            char cmiddle = this.get(middle).getLabelStart();
            if (cmiddle < c) {
                low = middle + 1;
                continue;
            }
            if (c < cmiddle) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public TrieEdge<V> get(char labelStart) {
        int i = this.search(labelStart, true);
        if (i < 0) {
            return null;
        }
        TrieEdge<V> ret = this.get(i);
        return ret;
    }

    public void put(String label, TrieNode<V> child) {
        int i = this.search(label.charAt(0), false);
        this.children.add(i + 1, new TrieEdge<V>(label, child));
    }

    public boolean remove(char labelStart) {
        int i = this.search(labelStart, true);
        if (i < 0) {
            return false;
        }
        this.children.remove(i);
        return true;
    }

    public void trim() {
        this.children.trimToSize();
    }

    public Iterator childrenForward() {
        return new ChildrenForwardIterator();
    }

    public Iterator labelsForward() {
        return new LabelForwardIterator();
    }

    public String toString() {
        V val = this.getValue();
        if (val != null) {
            return val.toString();
        }
        return "NULL";
    }

    private class ChildrenForwardIterator
    extends UnmodifiableIterator {
        int i = 0;

        private ChildrenForwardIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (this.i < TrieNode.this.children.size()) {
                return TrieNode.this.get(this.i++).getChild();
            }
            throw new NoSuchElementException();
        }
    }

    private class LabelForwardIterator
    extends UnmodifiableIterator {
        int i = 0;

        private LabelForwardIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (this.i < TrieNode.this.children.size()) {
                return TrieNode.this.get(this.i++).getLabel();
            }
            throw new NoSuchElementException();
        }
    }
}

