#'@docType data
#'@name FortytwoSTR
#'@title Information of 42 autosomal STRs
#'@description Example of the results achieved by "EvaluatePanel" function
#'@format A list of 3 vectors: i) a list nameed afmatrix containing 42 data.frames, each of which exhibiting the allele frequecies of alleles on a locus with the row names being the corresponding names of such alleles; ii) a data.fram with 1 row and 42 columns containing the frequencies of rare alleles on the 42 loci; and iii) a data.frame named indicators with 42 columns and 12 rows containing the main effeciency indicators of the 42 loci.

FortytwoSTR<-list(afmatrix = list(D19S433 = data.frame(Freq=c(0.0035,0.0372,0.0040,0.2767,0.0432,0.2584,0.1220,0.0734,0.1414,0.0104,0.0258,0.0025,0.0015),
                                                       row.names = c("11","12","12.2","13","13.2","14","14.2","15","15.2","16","16.2","17","17.2")),
                                  D5S818 = data.frame(Freq=c(0.0010,0.0174,0.0030,0.0749,0.1835,0.3264,0.2336,0.1503,0.0084,0.0015),
                                                      row.names = c("6","7","8","9","10","11","12","13","14","15")),
                                  D21S11 = data.frame(Freq=c(0.0005,0.0040,0.0005,0.0437,0.0099,0.2802,0.0030,0.2737,0.0134,0.0040,0.1105,0.0724,0.0005,0.0283,0.1047,0.0050,0.0010,0.0382,0.0005,0.0050,0.0005,0.0005),
                                                      row.names = c("26","27","27.2","28","28.2","29","29.2","30","30.2","30.3","31","31.2","31.3","32","32.2","33","33.1","33.2","34.1","34.2","35.2","36.2")),
                                  D18S51 = data.frame(Freq=c(0.0005,0.0005,0.0025,0.0317,0.2043,0.2128,0.1796,0.1260,0.0640,0.0382,0.0466,0.0362,0.0298,0.0164,0.0064,0.0030,0.0010,0.0005),
                                                      row.names = c("9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","27")),
                                  D6S1043 = data.frame(Freq=c(0.0005,0.0010,0.0367,0.0967,0.1379,0.1250,0.1260,0.0149,0.0030,0.0481,0.1766,0.1617,0.0005,0.0595,0.0010,0.0074,0.0020,0.0010,0.0005),
                                                       row.names = c("8","9","10","11","12","13","14","15","16","17","18","19","19.3","20","20.3","21","21.3","22","22.3")),
                                  D3S1358 = data.frame(Freq=c(0.0020,0.0417,0.3621,0.3353,0.1820,0.0704,0.0050,0.0015),
                                                       row.names = c("13","14","15","16","17","18","19","20")),
                                  D13S317 = data.frame(Freq=c(0.2570,0.1567,0.1394,0.2312,0.1696,0.0362,0.0089,0.0010),
                                                       row.names = c("8","9","10","11","12","13","14","15")),
                                  D7S820 = data.frame(Freq=c(0.0015,0.1528,0.0585,0.0064,0.1508,0.0010,0.3339,0.2440,0.0466,0.0045),
                                                      row.names = c("7","8","9","9.1","10","10.1","11","12","13","14")),
                                  D16S539 = data.frame(Freq=c(0.0104,0.2808,0.1235,0.2535,0.2078,0.1091,0.0139,0.0010),
                                                       row.names = c("8","9","10","11","12","13","14","15")),
                                  CSF1PO = data.frame(Freq=c(0.0035,0.0491,0.2426,0.2341,0.3834,0.0744,0.0124,0.0005),
                                                      row.names = c("8","9","10","11","12","13","14","15")),
                                  PentaD = data.frame(Freq=c(0.0005,0.0035,0.0079,0.0407,0.3034,0.1181,0.1563,0.1850,0.0005,0.1310,0.0437,0.0079,0.0015),
                                                      row.names = c("5","6","7","8","9","10","11","12","12.1","13","14","15","16")),
                                  vWA = data.frame(Freq=c(0.0005,0.0005,0.0020,0.2336,0.0372,0.1930,0.2490,0.1875,0.0818,0.0134,0.0015),
                                                   row.names = c("10","11","13","14","15","16","17","18","19","20","21")),
                                  D8S1179 = data.frame(Freq=c(0.0015,0.0005,0.1022,0.0818,0.1235,0.2143,0.2078,0.1776,0.0774,0.0109,0.0025),
                                                       row.names = c("8","9","10","11","12","13","14","15","16","17","18")),
                                  TPOX = data.frame(Freq=c(0.5247,0.1280,0.0184,0.2971,0.0303,0.0010,0.0005),
                                                    row.names = c("8","9","10","11","12","13","14")),
                                  PentaE = data.frame(Freq=c(0.0471,0.0005,0.0035,0.0040,0.0074,0.0441,0.1244,0.1066,0.0516,0.0779,0.1032,0.0923,0.0898,0.0005,0.0704,0.0005,0.0010,0.0605,0.0005,0.0526,0.0313,0.0154,0.0074,0.0040,0.0015,0.0015,0.0005),
                                                      row.names = c("5","6","7","8","9","10","11","12","13","14","15","16","17","17.4","18","18.3","18.4","19","19.4","20","21","22","23","24","25","26","27")),
                                  TH01 = data.frame(Freq=c(0.1086,0.2500,0.0516,0.5263,0.0402,0.0223,0.0005,0.0005),
                                                    row.names = c("6","7","8","9","9.3","10","11","12")),
                                  D12S391 = data.frame(Freq=c(0.0005,0.0134,0.0094,0.0893,0.0005,0.2291,0.0035,0.2108,0.0010,0.1820,0.1057,0.0903,0.0387,0.0144,0.0084,0.0030),
                                                       row.names = c("14","15","16","17","17.3","18","18.3","19","19.2","20","21","22","23","24","25","26")),
                                  D2S1338 = data.frame(Freq=c(0.0005,0.0104,0.0590,0.1027,0.1612,0.1314,0.0263,0.0407,0.2182,0.1622,0.0685,0.0159,0.0030),
                                                       row.names = c("15","16","17","18","19","20","21","22","23","24","25","26","27")),
                                  FGA = data.frame(Freq=c(0.0015,0.0005,0.0015,0.0218,0.0496,0.0516,0.1042,0.0010,0.1597,0.0060,0.2454,0.0069,0.1806,0.0040,0.1052,0.0020,0.0451,0.0020,0.0089,0.0010,0.0010,0.0005),
                                                   row.names = c("14","16.2","17","18","19","20","21","21.2","22","22.2","23","23.2","24","24.2","25","25.2","26","26.2","27","28","29","30")),
                                  D6S477 = data.frame(Freq=c(0.0005,0.0005,0.0131,0.0005,0.0039,0.0584,0.2137,0.1972,0.2888,0.1899,0.0248,0.0063,0.0019,0.0005),
                                                      row.names = c("9","9.2","10","10.2","11","12","13","14","15","16","17","18","19","20")),
                                  D18S535 = data.frame(Freq=c(0.0005,0.1845,0.0550,0.0170,0.1100,0.2386,0.2863,0.0964,0.0117),
                                                       row.names = c("8","9","10","11","12","13","14","15","16")),
                                  D19S253 = data.frame(Freq=c(0.1670,0.0380,0.0093,0.0214,0.0005,0.1602,0.0005,0.3280,0.2045,0.0643,0.0063),
                                                       row.names = c("7","8","9","10","10.1","11","11.1","12","13","14","15")),
                                  D15S659 = data.frame(Freq=c(0.0034,0.0019,0.0185,0.1500,0.2314,0.1319,0.0467,0.1636,0.1548,0.0813,0.0136,0.0029),
                                                       row.names = c("8","9","10","11","12","13","14","15","16","17","18","19")),
                                  D11S2368 = data.frame(Freq=c(0.0005,0.0039,0.0292,0.1456,0.0944,0.1709,0.0005,0.1806,0.2205,0.0969,0.0458,0.0102,0.0005,0.0005),
                                                        row.names = c("14","15","16","17","18","19","19.2","20","21","22","23","24","25","26")),
                                  D20S470 = data.frame(Freq=c(0.0005,0.0029,0.0019,0.0166,0.1504,0.0316,0.0433,0.1280,0.1534,0.1582,0.1802,0.0896,0.0346,0.0083,0.0005),
                                                       row.names = c("3","6","8","9","10","11","12","13","14","15","16","17","18","19","20")),
                                  D1S1656 = data.frame(Freq=c(0.0005,0.0604,0.0428,0.0867,0.0701,0.2924,0.0015,0.2434,0.0088,0.0867,0.0643,0.0112,0.0005,0.0239,0.0029,0.0039),
                                                       row.names = c("10","11","12","13","14","15","15.3","16","16.3","17","17.3","18","18.2","18.3","19","19.3")),
                                  GATA198B05 = data.frame(Freq=c(0.0073,0.0195,0.0789,0.1524,0.0682,0.0803,0.0910,0.2970,0.1733,0.0253,0.0063,0.0005),
                                                          row.names = c("14","15","16","17","18","19","20","21","22","23","24","25")),
                                  D7S3048 = data.frame(Freq=c(0.0058,0.0944,0.0798,0.1641,0.1105,0.0005,0.0740,0.1895,0.1641,0.0896,0.0209,0.0063,0.0005),
                                                       row.names = c("17","18","19","20","21","21.3","22","23","24","25","26","27","28")),
                                  D8S1132 = data.frame(Freq=c(0.0005,0.0112,0.0005,0.1057,0.1915,0.1875,0.1369,0.0010,0.1549,0.1184,0.0657,0.0204,0.0058),
                                                       row.names = c("15","16","16.1","17","18","19","20","20.3","21","22","23","24","25")),
                                  D4S2366 = data.frame(Freq=c(0.0010,0.2945,0.0521,0.3501,0.1480,0.0798,0.0628,0.0117),
                                                       row.names = c("8","9","10","11","12","13","14","15")),
                                  D21S1270 = data.frame(Freq=c(0.0005,0.0019,0.0015,0.2863,0.0652,0.0005,0.0419,0.0915,0.0910,0.0424,0.2522,0.0097,0.1071,0.0015,0.0068),
                                                        row.names = c("7","9","9.3","10","11","11.3","12","12.3","13","13.3","14","14.3","15","15.3","16")),
                                  D13S325 = data.frame(Freq=c(0.0005,0.0010,0.0010,0.0005,0.0088,0.0394,0.2381,0.3002,0.0005,0.2020,0.0005,0.1339,0.0010,0.0501,0.0166,0.0044,0.0015),
                                                       row.names = c("4","7","15","16","17","18","19","20","20.3","21","21.3","22","22.3","23","24","25","26")),
                                  D9S925 = data.frame(Freq=c(0.0005,0.0010,0.0015,0.0112,0.1363,0.2084,0.2925,0.0234,0.2269,0.0068,0.0886,0.0029),
                                                      row.names = c("10","11","12","13","14","15","16","16.3","17","17.3","18","19")),
                                  D3S3045 = data.frame(Freq=c(0.3343,0.0005,0.0331,0.0307,0.1315,0.0005,0.2025,0.1870,0.0721,0.0078),
                                                       row.names = c("9","9.2","10","11","12","12.1","13","14","15","16")),
                                  D14S608 = data.frame(Freq=c(0.0005,0.0613,0.2181,0.0122,0.1237,0.2292,0.2118,0.1105,0.0273,0.0049,0.0005),
                                                       row.names = c("4","6","7","8","9","10","11","12","13","14","15")),
                                  D10S1435 = data.frame(Freq=c(0.0341,0.0438,0.1602,0.3368,0.0010,0.2493,0.1480,0.0219,0.0049),
                                                        row.names = c("8","10","11","12","12.2","13","14","15","16")),
                                  D17S1290 = data.frame(Freq=c(0.0010,0.0370,0.0482,0.0093,0.0102,0.0097,0.2269,0.3048,0.1835,0.1198,0.0355,0.0102,0.0034,0.0005),
                                                        row.names = c("9","10","11","12","13","14","15","16","17","18","19","20","21","22")),
                                  D5S2500 = data.frame(Freq=c(0.0005,0.0029,0.0146,0.2966,0.2006,0.0394,0.0745,0.2765,0.0798,0.0136,0.0010),
                                                       row.names = c("8","9","10","11","12","13","14","15","16","17","18")),
                                  D3S1744 = data.frame(Freq=c(0.0186,0.0899,0.0940,0.0981,0.3471,0.2076,0.1023,0.0372,0.0052),
                                                       row.names = c("13","14","15","16","17","18","19","20","21")),
                                  D7S1517 = data.frame(Freq=c(0.0041,0.0031,0.0072,0.0145,0.0630,0.1260,0.1415,0.1457,0.0010,0.1467,0.0981,0.1716,0.0486,0.0186,0.0103),
                                                       row.names = c("15","16","17","18","19","20","21","22","22.2","23","24","25","26","27","28")),
                                  D2S441 = data.frame(Freq=c(0.0004,0.0018,0.0198,0.2535,0.0018,0.3540,0.0004,0.0277,0.1849,0.0004,0.0233,0.1202,0.0004,0.0101,0.0013),
                                                      row.names = c("8.1","9","9.1","10","10.1","11","11.1","11.3","12","12.3","13","14","14.1","15","16")),
                                  D10S1248 = data.frame(Freq=c(0.0013,0.0004,0.0004,0.0044,0.0885,0.3830,0.2210,0.1967,0.0841,0.0189,0.0009,0.0004),
                                                        row.names = c("8","9","10","11","12","13","14","15","16","17","18","19"))),
                  rare = data.frame(D19S433 = 0.00694100148735746,
                                    D5S818 = 0.00545364402578086,
                                    D21S11 = 0.0114030738720873,
                                    D18S51 = 0.00941993058998513,
                                    D6S1043 = 0.00991571641051066,
                                    D3S1358 = 0.0044620723847298,
                                    D13S317 = 0.0044620723847298,
                                    D7S820 = 0.00545364402578086,
                                    D16S539 = 0.0044620723847298,
                                    CSF1PO = 0.0044620723847298,
                                    PentaD = 0.00694100148735746,
                                    vWA = 0.0059494298463064,
                                    D8S1179 = 0.0059494298463064,
                                    TPOX = 0.00396628656420426,
                                    PentaE = 0.0138820029747149,
                                    TH01 = 0.0044620723847298,
                                    D12S391 = 0.00842835894893406,
                                    D2S1338 = 0.00694100148735746,
                                    FGA = 0.0114030738720873,
                                    D6S477 = 0.0072992700729927,
                                    D18S535 = 0.0048661800486618,
                                    D19S253 = 0.00583941605839416,
                                    D15S659 = 0.00632603406326034,
                                    D11S2368 = 0.0072992700729927,
                                    D20S470 = 0.00778588807785888,
                                    D1S1656 = 0.00827250608272506,
                                    GATA198B05 = 0.00632603406326034,
                                    D7S3048 = 0.00681265206812652,
                                    D8S1132 = 0.00681265206812652,
                                    D4S2366 = 0.00437956204379562,
                                    D21S1270 = 0.00778588807785888,
                                    D13S325 = 0.00875912408759124,
                                    D9S925 = 0.00632603406326034,
                                    D3S3045 = 0.00535279805352798,
                                    D14S608 = 0.00583941605839416,
                                    D10S1435 = 0.0048661800486618,
                                    D17S1290 = 0.0072992700729927,
                                    D5S2500 = 0.00583941605839416,
                                    D3S1744 = 0.00999000999000999,
                                    D7S1517 = 0.015984015984016,
                                    D2S441 = 0.00703915530136384,
                                    D10S1248 = 0.00571931368235812),
                  indicators = data.frame(D19S433 = c(13,0.8123404,0.8800354,0.0015000,0.0594559,0.9405441,0.4613745,0.6358102,0.8177664,0.4388683,0.2398071,0.7881006,1008),
                                          D5S818 = c(10,0.77663616,0.8629291,0.00100000,0.08377921,0.91622079,0.38840147,0.56750017,0.75127141,0.35441283,0.17542356,0.74274835,1008),
                                          D21S11 = c(22,0.81362128,0.8523652,0.00050000,0.05739496,0.94260504,0.46989994,0.64305349,0.82657634,0.45490005,0.25242022,0.79096335,1008),
                                          D18S51 = c(18,0.85358842,0.9037995,0.00050000,0.03776025,0.96223975,0.54783589,0.70961242,0.87672649,0.52689429,0.32125748,0.83726452,1008),
                                          D6S1043 = c(19,0.87530298,0.9239309,0.00050000,0.02847737,0.97152263,0.59481016,0.74770943,0.90245036,0.57057729,0.36530546,0.86237496,1008),
                                          D3S1358 = c(8,0.7166072,0.8189797,0.0015000,0.1296670,0.8703330,0.3006794,0.4720298,0.6520527,0.2678137,0.1193670,0.6672516,1008),
                                          D13S317 = c(8,0.80635550,0.9215491,0.00100000,0.06596698,0.93403302,0.43659497,0.61409332,0.79295716,0.39701906,0.20818447,0.77788671,1008),
                                          D7S820 = c(10,0.77722804,0.8635867,0.00100000,0.08220163,0.91779837,0.39321415,0.57229216,0.75783448,0.36432582,0.18139261,0.74465376,1008),
                                          D16S539 = c(8,0.78625084,0.8985724,0.00100000,0.07879172,0.92120828,0.40098458,0.57965389,0.76103968,0.36190334,0.18194582,0.75314782,1008),
                                          CSF1PO = c(8,0.7312344,0.8356965,0.0005000,0.1163585,0.8836415,0.3210644,0.4964556,0.6793269,0.2901706,0.1324603,0.6871109,1008),
                                          PentaD = c(13,0.81447914,0.8823524,0.00050000,0.05809889,0.94190111,0.46304384,0.63833967,0.81937705,0.43761163,0.23835682,0.79079824,1008),
                                          vWA = c(11,0.80276340,0.8830397,0.00050000,0.06831249,0.93168751,0.43065256,0.60799356,0.78742822,0.39195525,0.20480881,0.77335319,1008),
                                          D8S1179 = c(11,0.8408463,0.9249309,0.0005000,0.0452689,0.9547311,0.5113916,0.6805574,0.8517777,0.4799033,0.2766009,0.8209073,1008),
                                          TPOX = c(7,0.6187796,0.7219095,0.0005000,0.2068016,0.7931984,0.2054511,0.3587046,0.5263982,0.1921690,0.0729045,0.5573070,1008),
                                          PentaE = c(27,0.92027278,0.9556679,0.00050000,0.01199395,0.98800605,0.72083783,0.83809040,0.95646371,0.70739529,0.52545700,0.91463526,1008),
                                          TH01 = c(8,0.64393796,0.7359291,0.00050000,0.17278066,0.82721934,0.23857309,0.40866587,0.59598795,0.24660290,0.09495117,0.59793748,1008),
                                          D12S391 = c(16,0.84058520,0.8966242,0.00050000,0.04474224,0.95525776,0.51537423,0.68321292,0.85534918,0.48932544,0.28536975,0.82125604,1008),
                                          D2S1338 = c(13,0.86138958,0.9331720,0.00050000,0.03434468,0.96565532,0.56299877,0.72251087,0.88543566,0.53936708,0.33315646,0.84625775,1008),
                                          FGA = c(22,0.85190692,0.8924739,0.00050000,0.03826436,0.96173564,0.54429555,0.70708586,0.87524132,0.52357957,0.31729578,0.83557412,1008),
                                          D6S477 = c(14,0.79172030,0.8526219,0.00050000,0.07489409,0.92510591,0.41236384,0.59034711,0.77174461,0.37573327,0.19247225,0.76020665,1027),
                                          D18S535 = c(9,0.80221800,0.9024952,0.00050000,0.06687496,0.93312504,0.43594997,0.61298004,0.79496677,0.40536480,0.21333744,0.77446076,1027),
                                          D19S253 = c(11,0.79087958,0.8699675,0.00050000,0.07268361,0.92731639,0.41840460,0.59683561,0.78180436,0.39175338,0.20180305,0.76192732,1027),
                                          D15S659 = c(12,0.84648706,0.9234404,0.00190000,0.04211716,0.95788284,0.52522139,0.69204221,0.86130952,0.49590756,0.29140494,0.82793612,1027),
                                          D11S2368 = c(14,0.84698572,0.9121385,0.00050000,0.04192382,0.95807618,0.52631096,0.69288384,0.86191115,0.49701826,0.29250044,0.82847527,1027),
                                          D20S470 = c(15,0.86750926,0.9294742,0.00050000,0.03202248,0.96797752,0.57508287,0.73227477,0.89147508,0.54919694,0.34349766,0.85304058,1027),
                                          D1S1656 = c(16,0.82489594,0.8798890,0.00050000,0.05033194,0.94966806,0.49452485,0.66496099,0.84595990,0.48245573,0.27613071,0.80522544,1027),
                                          GATA198B05 = c(12,0.83181324,0.9074326,0.00050000,0.04718024,0.95281976,0.50383197,0.67388741,0.85143397,0.48604703,0.27979827,0.81291979,1027),
                                          D7S3048 = c(13,0.86872768,0.9411217,0.00050000,0.03136129,0.96863871,0.57796804,0.73479059,0.89342972,0.55218460,0.34590131,0.85459881,1027),
                                          D8S1132 = c(13,0.85535160,0.9266309,0.00050000,0.03799838,0.96200162,0.54383427,0.70758575,0.87270982,0.51364206,0.30819255,0.83827638,1027),
                                          D4S2366 = c(8,0.75563156,0.8635789,0.00100000,0.09634305,0.90365695,0.36306955,0.54117106,0.72936985,0.34021325,0.16279508,0.71900445,1027),
                                          D21S1270 = c(15,0.8183505,0.8768041,0.0005000,0.0549342,0.9450658,0.4769574,0.6498553,0.8316160,0.4593395,0.2561015,0.7964128,1027),
                                          D13S325 = c(17,0.79001416,0.8393900,0.00050000,0.07485733,0.92514267,0.41380322,0.59151215,0.77488154,0.38295717,0.19678294,0.75925088,1027),
                                          D9S925 = c(12,0.79237078,0.8644045,0.00050000,0.07395607,0.92604393,0.41491163,0.59300645,0.77506144,0.38010209,0.19490149,0.76152460,1027),
                                          D3S3045 = c(10,0.78767816,0.8751980,0.00050000,0.07443913,0.92556087,0.41337808,0.59218009,0.77787549,0.38755488,0.19813772,0.75831959,1027),
                                          D14S608 = c(11,0.82285224,0.9051375,0.00050000,0.05533002,0.94466998,0.47351707,0.64724116,0.82393222,0.44062678,0.24295620,0.79890355,1027),
                                          D10S1435 = c(9,0.77326136,0.8699190,0.00100000,0.08494712,0.91505288,0.38699013,0.56583515,0.75161039,0.35858889,0.17750067,0.73972465,1027),
                                          D17S1290 = c(14,0.80223510,0.8639455,0.00050000,0.06559167,0.93440833,0.44170345,0.61776316,0.80157520,0.41843722,0.22335045,0.77575438,1027),
                                          D5S2500 = c(11,0.78145740,0.8596031,0.00050000,0.08024466,0.91975534,0.40068854,0.57842008,0.76322908,0.37198822,0.18808848,0.74897361,1027),
                                          D3S1744 = c(9,0.79766008,0.8973676,0.00520000,0.06516286,0.93483714,0.43994327,0.61791919,0.80599095,0.42550193,0.22508438,0.77343867,500),
                                          D7S1517 = c(15,0.87520968,0.9377247,0.00100000,0.02859729,0.97140271,0.59416658,0.74721821,0.90194853,0.56944819,0.36426410,0.86218502,500),
                                          D2S441 = c(15,0.7599727,0.8142564,0.0004000,0.0940139,0.9059861,0.3664921,0.5448627,0.7312009,0.3393741,0.1639737,0.7235719,1136),
                                          D10S1248 = c(12,0.7504945,0.8187213,0.0004000,0.0989944,0.9010056,0.3534735,0.5329678,0.7207150,0.3291404,0.1550730,0.7137531,1136),
                                          row.names = c("nofalleles","Het_unadjusted","Het_adjusted","MAF","PM","DP","PED","PET","PEdoubledoubt","RGE","RGEwithoutmother","PIC","Number_of_individuals")),
                  panelparas=data.frame(parameters=c("TDP","CPED","CPET","CPE double doubt","CRGE","CRGE without mother"),
                                        values=c(-51.310635,-11.343008,-18.385382,-30.911028,-10.488279,-5.093494)))
