check_rmd <- function(){
    isTRUE(getOption("knitr.in.progress"))
}

## This function is used at the beginning of the julia_call interface
## to eraze the previous outputs
output_reset <- function(){
    julia$current_text <- NULL
    julia$current_plot <- NULL
}

## This function is used at the end of the julia_call interface
## to return the current output.
output_return <- function(){
    if (!is.null(julia$current_plot)) return(julia$current_plot)
    if (!is.null(julia$current_text)) return(julia$current_text)
}

## This function is used at the beginning of Julia plot_display function
## we generate a figure name and return it to Julia,
## which could be later be used by Julia to save the plot.
## After saving the plot, Julia will call the finish_plot function.
begin_plot <- function(){
    options <- knitr::opts_current$get()
    if (is.null(options$Jfig.cur)) {
        number <- 1L
    }
    else {
        number <- options$Jfig.cur
    }
    path <- knitr::fig_chunk(label = options$label,
                             ext = options$dev, number = paste0("J", number))
    .julia$pending_plot <- knitr::include_graphics(path)
    .julia$pending_plot_number <- number
    path
}

## This function is used by Julia plot_display function
finish_plot <- function(){
    knitr::opts_current$set(Jfig.cur = .julia$pending_plot_number + 1L)
    julia$current_plot <- .julia$pending_plot
}

## This function is used by Julia text_display function
## x will be the text representation of the Julia result.
text_display <- function(x, options = knitr::opts_current$get()){
    wrap_character <- do.call(":::", list("knitr", quote(wrap.character)))
    text <- knitr::asis_output(wrap_character(x, options = options))
    julia$current_text <- text
}

## The idea of the engine is quite simple,
## we parse the Julia code line by line to see if it is a complete
## Julia command, if it is, evaluate it using julia_command function.
## then we will wrap the result into the document.
## Note that the result here is actually
## generated by function finish_plot or text_display and
## returned by output_return

#' Julia language engine in R Markdown
#'
#' Julia language engine in R Markdown
#'
#' @param options a list of chunk options
#'
#' @examples
#'
#' knitr::knit_engines$set(julia = JuliaCall::eng_juliacall)
#'
#' @export
eng_juliacall <- function(options) {
    code <- options$code

    wrap_ <- do.call(":::", list("knitr", quote(wrap)))
    wrap <- function(x) wrap_(x, options = options)

    if (!options$eval) {
        knitr::engine_output(options, paste(code, collapse = "\n"), "")
    }

    if (!.julia$initialized) {
        julia_setup()
    }

    doc <- character()
    buffer <- character()
    ss <- character()

    for (line in code) {
        buffer <- paste(c(buffer, line), collapse = "\n")
        ss <- paste(c(ss, line), collapse = "\n")

        if (length(buffer) && (!julia_call("JuliaCall.incomplete", buffer))) {
            out <- tryCatch(julia_command(buffer),
                            warning = function(w) w,
                            error = function(e) e)
            out <- wrap(out)
            if (options$results != 'hide' && length(out) > 0  && nchar(trimws(out)) > 0) {
                if (length(options$echo) > 1L || options$echo) {
                    doc <- paste(c(doc,
                                   knitr::knit_hooks$get('source')(ss, options)
                                   ),
                                 collapse = "\n")
                    ss <- character()
                }
                doc <- paste(c(doc, out), collapse = "\n")
            }
            buffer <- character()
        }
    }
    if (length(ss) > 0) {
        if (length(options$echo) > 1L || options$echo) {
            doc <- paste(c(doc,
                           knitr::knit_hooks$get('source')(ss, options)
                           ),
                         collapse = "\n")
            ss <- character()
        }
    }
    doc
}
