% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_JAGSmodel.R
\name{paste_linpred}
\alias{paste_linpred}
\title{Write a linear predictor}
\usage{
paste_linpred(parname, parelmts, matnam, index, cols, scale_pars,
  isgk = FALSE)
}
\arguments{
\item{parname}{character string; name fo the parameter (e.g., "beta")}

\item{index}{character string; name of the index (e.g., "i" or "ii")}

\item{cols}{integer vector; indices of the columns of \code{matname}, should have
the same length as \code{parlemts}}

\item{scale_pars}{matrix with row names according to the column names of
\code{matname} and columns "center" and "scale"; or NULL}

\item{isgk}{logical; is this linear predictor within the Gauss-Kronrod
quadrature?}

\item{parlemts}{integer vector; indices of the parameter vector to be used;
should have the same length as \code{cols}}

\item{matname}{character string; name of the data matrix}
}
\description{
Construct a linear predictor from parameter names and indices, the name of
the data matrix and corresponding columns, and apply scaling to the data
if necessary.
}
\keyword{internal}
