/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import org.omegahat.Environment.DataStructures.Decrementable;
import org.omegahat.Environment.DataStructures.Incrementable;
import org.omegahat.Environment.DataStructures.ObjectIncrementable;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.Parse.AssignExpression;
import org.omegahat.Environment.Parser.Parse.ConstantExpression;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.FieldAccess;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.Parser.Parse.NumberExpression;
import org.omegahat.Environment.Parser.Parse.UnaryExpression;

public class UpdateUnaryExpression
extends UnaryExpression {
    protected boolean prefix = false;

    public UpdateUnaryExpression(Object object, int n) {
        super(object, n);
    }

    public UpdateUnaryExpression(Object object, int n, boolean bl) {
        super(object, n);
        this.isPrefix(bl);
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        Database database = null;
        Object object = null;
        String string = null;
        if (this.expression instanceof Name) {
            string = evaluator.asObjectName((Name)this.expression);
            database = evaluator.which(string);
        } else if (this.expression instanceof String) {
            string = (String)this.expression;
            database = evaluator.which((String)this.expression);
        } else {
            object = this.expression instanceof ExpressionInt ? ((ExpressionInt)this.expression).eval(evaluator) : this.expression;
        }
        if (database != null) {
            object = database.get(string);
        } else {
            database = evaluator.defaultDatabase();
        }
        if (object == null) {
            object = new Integer(0);
        }
        Object object2 = object;
        object = this.operate(object);
        if (database != null && this.isReassignment()) {
            if (string != null) {
                database.assign(string, object);
            } else if (this.expression instanceof FieldAccess) {
                new AssignExpression(this.expression, new ConstantExpression(object)).eval(evaluator);
            }
        }
        return this.isPrefix() ? object : object2;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public boolean isPrefix(boolean bl) {
        this.prefix = bl;
        return this.isPrefix();
    }

    public Object operate(Object object) {
        if (object instanceof ObjectIncrementable) {
            return ((ObjectIncrementable)object).increment(object);
        }
        int n = 1;
        switch (this.op()) {
            case 143: {
                n = 1;
                break;
            }
            case 144: {
                n = -1;
                break;
            }
        }
        if (object instanceof Incrementable) {
            ((Incrementable)object).increment(n);
        } else if (object instanceof Decrementable) {
            ((Decrementable)object).decrement(-1 * n);
        } else if (this.isNumber(object)) {
            object = UpdateUnaryExpression.toNumber(NumberExpression.asNumber(object) + (double)n, object);
        }
        return object;
    }

    public static Object toNumber(double d, Object object) {
        Number number = object instanceof Integer ? (Number)new Integer((int)d) : (Number)new Double(d);
        return number;
    }

    public String toString() {
        String string = "";
        string = this.prefix ? String.valueOf(this.opString()) + this.expression.toString() : String.valueOf(this.expression.toString()) + this.opString();
        return string;
    }
}

