/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import java.util.Enumeration;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Language.Closure;
import org.omegahat.Environment.Language.Function;
import org.omegahat.Environment.Language.LazyFunction;
import org.omegahat.Environment.Language.TailRecursiveClosure;
import org.omegahat.Environment.Language.TailRecursiveFunction;
import org.omegahat.Environment.Parser.Parse.AssignExpression;
import org.omegahat.Environment.Parser.Parse.BasicExpression;
import org.omegahat.Environment.Parser.Parse.Comment;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.FlowControl;
import org.omegahat.Environment.Parser.Parse.FormalComment;
import org.omegahat.Environment.Parser.Parse.FunctionParameterModifier;
import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Parser.Parse.LocalVariable;
import org.omegahat.Environment.Parser.Parse.MethodCall;
import org.omegahat.Environment.Parser.Parse.MethodParameter;
import org.omegahat.Environment.Parser.Parse.Modifier;
import org.omegahat.Environment.Parser.Parse.Name;

public class FunctionExpression
extends BasicExpression {
    protected Function function;
    protected ExpressionInt body;
    protected List args;
    protected Name returnType;
    protected List exceptions;
    protected String name;
    protected FunctionParameterModifier lazy;
    protected Comment documentation;

    public FunctionExpression() {
    }

    public FunctionExpression(Function function) {
        this.function(function);
    }

    public FunctionExpression(ExpressionInt expressionInt, List list2, Name name, List list3, String string) {
        this(expressionInt, list2, name, list3, string, null);
    }

    public FunctionExpression(ExpressionInt expressionInt, List list2, Name name, List list3, String string, FunctionParameterModifier functionParameterModifier) {
        this.body = expressionInt;
        this.args = list2;
        this.returnType = name;
        this.exceptions = list3;
        this.name = string;
        this.lazy = functionParameterModifier;
    }

    public FunctionExpression(ExpressionInt expressionInt, List list2, Name name, List list3, String string, FunctionParameterModifier functionParameterModifier, Comment comment) {
        this(expressionInt, list2, name, list3, string, functionParameterModifier);
        this.documentation = comment;
    }

    public List args() {
        return this.args;
    }

    public ExpressionInt body() {
        return this.body;
    }

    public ExpressionInt body(ExpressionInt expressionInt) {
        this.body = expressionInt;
        return this.body();
    }

    public Function createFunction() throws ClassNotFoundException {
        return this.createFunction(this.body, this.args, this.returnType, this.exceptions, this.name, this.lazy);
    }

    public Function createFunction(ExpressionInt expressionInt, List list2, Name name, List list3, String string) throws ClassNotFoundException {
        return this.createFunction(expressionInt, list2, name, list3, string, null);
    }

    public Function createFunction(ExpressionInt expressionInt, List list2, Name name, List list3, String string, FunctionParameterModifier functionParameterModifier) throws ClassNotFoundException {
        return this.createFunction(expressionInt, list2, name, list3, string, functionParameterModifier, null, null);
    }

    public Function createFunction(ExpressionInt expressionInt, List list2, Name name, List list3, String string, FunctionParameterModifier functionParameterModifier, Evaluator evaluator) throws ClassNotFoundException {
        return this.createFunction(expressionInt, list2, name, list3, string, functionParameterModifier, null, evaluator);
    }

    public Function createFunction(ExpressionInt expressionInt, List list2, Name name, List list3, String string, FunctionParameterModifier functionParameterModifier, Comment comment) throws ClassNotFoundException {
        return this.createFunction(expressionInt, list2, name, list3, string, functionParameterModifier, comment, null);
    }

    public Function createFunction(ExpressionInt expressionInt, List list2, Name name, List list3, String string, FunctionParameterModifier functionParameterModifier, Comment comment, Evaluator evaluator) throws ClassNotFoundException {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = this.hasLazyArguments(list2) || functionParameterModifier != null && functionParameterModifier.isLazy();
        if (!(expressionInt instanceof List)) {
            expressionInt = new List((Object)expressionInt);
        }
        if (expressionInt != null && ((List)expressionInt).size() > 0) {
            bl2 = this.isTailRecursive(expressionInt, string);
        }
        Function function = expressionInt != null && ((List)expressionInt).size() > 0 && this.isClosure(expressionInt) ? (bl2 ? new TailRecursiveClosure(expressionInt, list2, name, list3, string, evaluator) : new Closure(expressionInt, list2, name, list3, string, evaluator)) : (bl ? new LazyFunction(expressionInt, list2, name, list3, string, functionParameterModifier, evaluator) : (bl2 ? new TailRecursiveFunction(expressionInt, list2, name, list3, string, evaluator) : new Function(expressionInt, list2, name, list3, string, evaluator)));
        if (comment != null && comment instanceof FormalComment) {
            function.setDocumentation(comment);
        }
        return function;
    }

    public Comment documentation() {
        return this.documentation;
    }

    public Comment documentation(Comment comment) {
        this.documentation = comment;
        return this.documentation();
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        this.function(this.createFunction(this.body, this.args, this.returnType, this.exceptions, this.name, this.lazy, this.documentation, evaluator));
        return this.function();
    }

    public Function function() {
        return this.function;
    }

    public Function function(Function function) {
        this.function = function;
        return this.function();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLazyArguments(List list2) {
        if (list2 == null || list2.size() == 0) {
            return false;
        }
        Enumeration enumeration = list2.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof AssignExpression) {
                object = ((AssignExpression)object).element(0);
            }
            if (!(object instanceof MethodParameter) || !((MethodParameter)object).isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean isClosure(ExpressionInt expressionInt) {
        boolean bl = false;
        if (expressionInt instanceof List) {
            Enumeration enumeration = ((List)expressionInt).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof LocalVariable) || !(bl = this.isStaticVariable((LocalVariable)e))) {
                    continue;
                }
                break;
            }
        } else if (expressionInt instanceof LocalVariable) {
            bl = this.isStaticVariable((LocalVariable)expressionInt);
        }
        return bl;
    }

    protected boolean isStaticVariable(LocalVariable localVariable) {
        Modifier modifier = localVariable.modifiers();
        if (modifier == null) {
            return false;
        }
        return modifier.isStatic();
    }

    public boolean isTailRecursive(ExpressionInt expressionInt, String string) {
        boolean bl = false;
        if (expressionInt instanceof List) {
            List list2 = (List)expressionInt;
            ExpressionInt expressionInt2 = (ExpressionInt)list2.elementAt(list2.size() - 1);
            if (expressionInt2 instanceof FlowControl && ((FlowControl)expressionInt2).type() == 42) {
                expressionInt2 = ((FlowControl)expressionInt2).expression();
            }
            if (expressionInt2 instanceof MethodCall) {
                String string2 = ((MethodCall)expressionInt2).methodName();
                bl = ((MethodCall)expressionInt2).qualifier() == null && string2.equals(string) || string2.equals("this");
            }
        }
        return bl;
    }

    public String setName(String string) {
        this.name = string;
        return this.getName();
    }

    public String toString() {
        if (this.function() != null) {
            return this.function().toString();
        }
        return "Unevaluated function definition";
    }
}

