% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styler.R
\name{param_summary}
\alias{param_summary}
\title{Calculates summaries for a parameter}
\usage{
param_summary(x, trans = function(x) x, ..., na.rm = TRUE)
}
\arguments{
\item{x}{a data vector to operate on}

\item{trans}{A function to transform the data. Used for summaries,
but not p-values. Defaults to the identity function.}

\item{\dots}{Additional arguments passed to \code{formatPval}
to control p-value printing.}

\item{na.rm}{Logical whether to remove NA values. Defaults to \code{TRUE}}
}
\value{
A data frame of summary statistics
}
\description{
This function takes a vector of statistics and calculates
several summaries: mean, median, 95% CI, and
the empirical p-value, that is, how many fall on the other
side of zero.
}
\examples{

param_summary(rnorm(100))
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}
