% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{acfByID}
\alias{acfByID}
\title{Estimate the effective sample size from longitudinal data}
\usage{
acfByID(xvar, timevar, idvar, data, lag.max = 10L,
  na.function = c("na.approx", "na.spline", "na.locf"), ...)
}
\arguments{
\item{xvar}{A character string giving the variable name of
the variable to calculate autocorrelations on.}

\item{timevar}{A character string giving the variable name of
the time variable.}

\item{idvar}{A character string giving the variable name of
the ID variable.  Can be missing if only one time series
provided, in which case one will be created.}

\item{data}{A data.table containing the variables
used in the formula.  This is a required argument.
If a data.frame, it will silently coerce to a data.table.
If not a data.table or data.frame, it will attempt to coerce,
with a message.}

\item{lag.max}{An integer of the maximum lag to estimate. Must be
equal to or greater than the number of observations
for all IDs in the dataset.}

\item{na.function}{A character string giving the name of the function
to use to address any missing data.  Functions come from the
\pkg{zoo} package, and must be one of:
\dQuote{na.approx}, \dQuote{na.spline}, \dQuote{na.locf}.}

\item{...}{Additional arguments passed to \code{zoo}.}
}
\value{
A data.table of the estimated autocorrelations by ID and lag
}
\description{
This function estimates the (approximate) effective sample
size.
}
\examples{
## example 1
dat <- data.table(
  x = sin(1:30),
  time = 1:30,
  id = 1)
acfByID("x", "time", "id", data = dat)

## example 2
dat2 <- data.table(
  x = c(sin(1:30), sin((1:30)/10)),
  time = c(1:30, 1:30),
  id = rep(1:2, each = 30))
dat2$x[4] <- NA

res <- acfByID("x", "time", "id", data = dat2, na.function = "na.approx")

ggplot(res, aes(factor(Lag), AutoCorrelation)) +
  geom_boxplot()

## clean up
rm(dat, dat2, res)
}
\references{
For details, see
Campbell, M. K., Mollison, J., & Grimshaw, J. M. (2001).
Cluster trials in implementation research: estimation of
intracluster correlation coefficients and sample size.
\emph{Statistics in Medicine, 20}(3), 391-399.
}
\keyword{multivariate}
