% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{TukeyHSDgg}
\alias{TukeyHSDgg}
\title{Tukey HSD Plot}
\usage{
TukeyHSDgg(x, y, d, ci = 0.95, ordered = FALSE, ...)
}
\arguments{
\item{x}{X}

\item{y}{Y}

\item{d}{D}

\item{ci}{Confidence interval, defaults to .95}

\item{ordered}{Logical, defaults to \code{FALSE}.}

\item{\ldots}{Additional arguments passed on.}
}
\value{
A ggplot graph object.
}
\description{
This calculates and displays means, confidence intervals
as well as which groups are different based on Tukey's HSD.
Inspired by http://stackoverflow.com/questions/18771516/is-there-a-function-to-add-aov-post-hoc-testing-results-to-ggplot2-boxplot
}
\examples{
TukeyHSDgg("cyl", "mpg", mtcars)
TukeyHSDgg("Species", "Sepal.Length", iris, ci = .9)

}
\keyword{plot}

