% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standarize_variable.R
\name{standardize_variable}
\alias{standardize_variable}
\alias{standardise_variable}
\title{Standardize variables in a data set.}
\usage{
standardize_variable(data, cols = dplyr::everything(), suffix = NULL)

standardise_variable(data, cols = dplyr::everything(), suffix = NULL)
}
\arguments{
\item{data}{A data frame containing the variables to standardize.}

\item{cols}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Columns to standardize.
Defaults to \code{\link[dplyr:reexports]{dplyr::everything()}}.}

\item{suffix}{A character suffix to be added to the scaled variables names.
When suffix is set to\code{NULL}, the  \code{standardize_variable()} function will
overwrite the scaled variables. Defaults to \code{NULL}.}
}
\value{
A data frame with the standardized columns.
}
\description{
\code{standardize_variable()} standardizes the selected columns in a
data.frame using \code{\link[base:scale]{base::scale()}}. By default, this function
overwrites the column to be scaled. Use the \code{suffix} argument to avoid this
behavior.

\code{standardize_variable()} and \code{standardise_variable()} are synonyms.
}
\section{\code{standardize_variable} and \code{grouped_df}}{


Note that \code{standardize_variable} ignores grouping. Meaning that if you
call this function on a grouped data frame (see \link[dplyr:grouped_df]{dplyr::grouped_df}), the
\strong{overall} variables' mean and standard deviation will be used for the
standardization.
}

\examples{
ho_et_al \%>\%
  standardize_variable(sdo)

ho_et_al \%>\%
  standardize_variable(c(sdo, linkedfate), suffix = "scaled")
}
