% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_models.R
\name{extract_models}
\alias{extract_models}
\title{Extracts models from a mediation_model object}
\usage{
extract_models(mediation_model)
}
\arguments{
\item{mediation_model}{An object of class \code{mediation_model}.}
}
\value{
A list of \code{lm} objects.
}
\description{
When conducting a joint-significant test, different models are
fitted to the data. This function helps accessing the models used in an
object of class \code{mediation_model}.
}
\examples{
data(ho_et_al)
ho_et_al$condition_c <- build_contrast(ho_et_al$condition,
                                       "Low discrimination",
                                       "High discrimination")
my_model <-
  mdt_simple(data = ho_et_al,
             IV = condition_c,
             DV = hypodescent,
             M = linkedfate)

extract_models(my_model)

}
\seealso{
Other extract functions: 
\code{\link{extract_model}()},
\code{\link{extract_tidy_models}()}
}
\concept{extract functions}
