% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpower.R
\name{tpower}
\alias{tpower}
\title{Compute a truncated power function.}
\usage{
tpower(x, knot, p)
}
\arguments{
\item{x}{a vector on which the basis is calculated.}

\item{knot}{a scalar giving the truncation point.}

\item{p}{a scalar power for the basis, e.g. \code{p = 3} for cubic TPF.}
}
\value{
a vector with the truncated power function.
}
\description{
Compute a truncated power function.
}
\examples{
library(JOPS)
# Basis  on grid
x = seq(0, 4, length = 500)
knots = 0:3
Y = outer(x, knots, tpower, 1)
matplot(x, Y, type ='l', lwd = 2, xlab = 'x', ylab = '',
main ='Linear TPF basis')

}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers
}
