/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

public class MapSegmentEntry {
    public double[] xp;
    public double[] yp;
    public boolean isLake;
    public boolean hasBorder;
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;

    public MapSegmentEntry() {
        this.isLake = false;
        this.hasBorder = true;
    }

    public MapSegmentEntry(double[] xpt, double[] ypt, boolean lake, boolean border) {
        this.isLake = lake;
        this.hasBorder = border;
        this.xp = new double[xpt.length];
        this.yp = new double[xpt.length];
        for (int i = 0; i < xpt.length; ++i) {
            this.xp[i] = xpt[i];
            double d = this.yp[i] = i < ypt.length ? ypt[i] : 0.0;
            if (i == 0) {
                this.minX = this.maxX = xpt[0];
                this.minY = this.maxY = ypt[0];
            }
            if (xpt[i] < this.minX) {
                this.minX = xpt[i];
            }
            if (xpt[i] > this.maxX) {
                this.maxX = xpt[i];
            }
            if (ypt[i] < this.minY) {
                this.minY = ypt[i];
            }
            if (!(ypt[i] > this.maxY)) continue;
            this.maxY = ypt[i];
        }
    }

    public MapSegmentEntry(double[] xpt, double[] ypt, int offset, int length, boolean lake, boolean border) {
        this.isLake = lake;
        this.hasBorder = border;
        if (xpt.length < offset + length) {
            length = xpt.length - offset;
        }
        if (length < 0) {
            length = 0;
        }
        this.xp = new double[length];
        this.yp = new double[length];
        for (int i = offset; i < offset + length; ++i) {
            this.xp[i - offset] = xpt[i];
            double d = this.yp[i - offset] = i < ypt.length ? ypt[i] : 0.0;
            if (i == offset) {
                this.minX = this.maxX = xpt[i];
                this.minY = this.maxY = ypt[i];
            }
            if (xpt[i] < this.minX) {
                this.minX = xpt[i];
            }
            if (xpt[i] > this.maxX) {
                this.maxX = xpt[i];
            }
            if (ypt[i] < this.minY) {
                this.minY = ypt[i];
            }
            if (!(ypt[i] > this.maxY)) continue;
            this.maxY = ypt[i];
        }
    }

    public void fixBoundingBox() {
        this.maxY = 0.0;
        this.minY = 0.0;
        this.maxX = 0.0;
        this.minX = 0.0;
        for (int i = 0; i < this.xp.length; ++i) {
            if (i == 0) {
                this.minX = this.maxX = this.xp[0];
                this.minY = this.maxY = this.yp[0];
            }
            if (this.xp[i] < this.minX) {
                this.minX = this.xp[i];
            }
            if (this.xp[i] > this.maxX) {
                this.maxX = this.xp[i];
            }
            if (this.yp[i] < this.minY) {
                this.minY = this.yp[i];
            }
            if (!(this.yp[i] > this.maxY)) continue;
            this.maxY = this.yp[i];
        }
    }
}

