/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.JGR;

public class CodeCompletion
extends JPanel {
    public static final int C_HEIGHT = 100;
    public static final int C_WIDTH = 160;
    private static final long serialVersionUID = 2527975358381656662L;
    private static CodeCompletion instance = null;
    private String pattern = null;
    private Vector completions = JGR.KEYWORDS;
    private Vector _completions = new Vector();
    private JList completionsList = new JList();

    private CodeCompletion() {
        this.setMinimumSize(new Dimension(160, 100));
        this.setPreferredSize(new Dimension(160, 100));
        this.setMaximumSize(new Dimension(160, 100));
        this.setLayout(new GridLayout(1, 1));
        this.add(new JScrollPane(this.completionsList));
    }

    public static CodeCompletion getInstance() {
        if (instance == null) {
            instance = new CodeCompletion();
        }
        return instance;
    }

    public int updateList(String pattern) {
        this.pattern = pattern;
        this._completions.clear();
        for (int i = 0; i < this.completions.size(); ++i) {
            String s = (String)this.completions.get(i);
            if (!s.startsWith(pattern)) continue;
            this._completions.add(s);
        }
        Collections.sort(this._completions);
        this.completionsList.setListData(this._completions);
        this.completionsList.setSelectedIndex(0);
        return this._completions.size();
    }

    public String getCompletion() {
        String val = this.completionsList.getSelectedValue().toString();
        if (val != null) {
            return val.replaceFirst(this.pattern, "");
        }
        return "";
    }

    public int updateFileList(String pattern) {
        this.pattern = pattern;
        return -1;
    }

    public void previous() {
        int cSel = this.completionsList.getSelectedIndex();
        if (cSel > 0) {
            this.completionsList.setSelectedIndex(--cSel);
            this.completionsList.ensureIndexIsVisible(cSel);
        }
    }

    public void next() {
        int cSel = this.completionsList.getSelectedIndex();
        if (cSel < this.completionsList.getModel().getSize() - 1) {
            this.completionsList.setSelectedIndex(++cSel);
            this.completionsList.ensureIndexIsVisible(cSel);
        }
    }
}

