% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{fr-remove_indicators}
\alias{fr-remove_indicators}
\title{Manipulation de la liste des indicateurs}
\arguments{
\item{x}{objet de type \code{\link{QR_matrix}} ou \code{\link{mQR_matrix}}.}

\item{...}{noms des variables à retirer (ou conserver).}
}
\value{
\code{remove_indicators()} renvoie le même objet \code{x} réduit par les drapeaux et les variables utilisés comme arguments \dots
Donc si l'entrée \code{x} est une matrice QR_matrix, un objet de la classe QR_matrix est renvoyé.
Si le code d'entrée \code{x} est une matrice mQR, un objet de la classe mQR_matrix est renvoyé.
}
\description{
Permet de retirer des indicateurs (fonction \code{remove_indicators()}) ou de n'en retenir que certains
(fonction \code{retain_indicators()}) d'objets \code{\link{QR_matrix}} ou \code{\link{mQR_matrix}}. Le nom des séries
(colonne "series") ne peut être enlevé.
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

# Compute the score
QR <- compute_score(QR, n_contrib_score = 2)

# Retain indicators
retain_indicators(QR, "score", "m7") # retaining "score" and "m7"
retain_indicators(QR, c("score", "m7")) # Same

# Remove indicators
QR <- retain_indicators(QR, "score") # removing "score"

extract_score(QR) # is NULL because we removed the score indicator

}
\keyword{internal}
