% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JATS_get.aff.R
\name{get.aff}
\alias{get.aff}
\title{get.aff}
\usage{
get.aff(x, remove.html = FALSE, letter.convert = TRUE)
}
\arguments{
\item{x}{a NISO-JATS coded XML file or text.}

\item{remove.html}{Logical. If TRUE removes all html tags.}

\item{letter.convert}{Logical. If TRUE converts hexadecimal and HTML coded characters to Unicode.}
}
\value{
Character vector with the extracted affiliation name/s.
}
\description{
Extracts the affiliation tag information from NISO-JATS coded XML file or text as a vector of affiliations.
}
\examples{
x<-"Some text <aff>Some affiliation</aff> some text"
get.aff(x)
x<-"TEXT <aff>Some affiliation</aff> TEXT <aff>Some other affiliation</aff> TEXT"
get.aff(x)
}
\seealso{
\code{\link[JATSdecoder]{JATSdecoder}} for simultaneous extraction of meta-tags, abstract, sectioned text and reference list.
}
