% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{vary_many_params}
\alias{vary_many_params}
\title{Generate copies of a \code{config} with all combinations of modified parameters}
\usage{
vary_many_params(cfg, param_rows, values_list)
}
\arguments{
\item{cfg}{Base \code{config} to make modified copies of}

\item{param_rows}{Numeric vector indicating the rows in the parameters
table where parameter values should be modified. Length must equal length
of values_list}

\item{values_list}{List of numeric vectors. The values of a vector
\code{values_list[[i]]} are the parameter values to use for the parameter
identified by \code{param_rows[[i]]}}
}
\value{
A list of \code{config}s
}
\description{
Generate copies of a \code{config} with all combinations of modified parameters
}
\examples{

# create new configs with different values for the parameter determining
# mortality of eggs (which is found in row 2) and that determining
# mortality of larvae (which is found in row 4)
cfgs <- vary_many_params(config_ex_1,
                        param_rows = c(2, 4),
                        values_list = list(c(0, 0.1), c(.99, .98)))

# inspect parameter rows 2 and 4 in each of the new configs to verify that we
# have the new values
lapply(cfgs, function(cfg) cfg$parameters[c(2, 4), 'param_value'])

}
