% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R
\name{createIhtPrior}
\alias{createIhtPrior}
\title{Create an IHT Cyclops prior object}
\usage{
createIhtPrior(
  K,
  penalty = "bic",
  exclude = c(),
  forceIntercept = FALSE,
  fitBestSubset = FALSE,
  initialRidgeVariance = 0.1,
  tolerance = 1e-08,
  maxIterations = 10000,
  threshold = 1e-06,
  delta = 0
)
}
\arguments{
\item{K}{Maximum # of non-zero covariates}

\item{penalty}{Specifies the IHT penalty; possible values are `BIC` or `AIC` or a numeric value}

\item{exclude}{A vector of numbers or covariateId names to exclude from prior}

\item{forceIntercept}{Logical: Force intercept coefficient into regularization}

\item{fitBestSubset}{Logical: Fit final subset with no regularization}

\item{initialRidgeVariance}{Numeric: variance used for algorithm initiation}

\item{tolerance}{Numeric: maximum abs change in coefficient estimates from successive iterations to achieve convergence}

\item{maxIterations}{Numeric: maximum iterations to achieve convergence}

\item{threshold}{Numeric: absolute threshold at which to force coefficient to 0}

\item{delta}{Numeric: change from 2 in ridge norm dimension}
}
\value{
An IHT Cyclops prior object of class inheriting from
\code{"cyclopsPrior"} for use with \code{fitCyclopsModel}.
}
\description{
\code{createIhtPrior} creates an IHT Cyclops prior object for use with \code{\link{fitCyclopsModel}}.
}
\examples{
prior <- createIhtPrior(K = 10)

}
