% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastIhtPrior.R
\name{createFastIhtPrior}
\alias{createFastIhtPrior}
\title{Create a fastIHT Cyclops prior object}
\usage{
createFastIhtPrior(
  K,
  penalty = 0,
  exclude = c(),
  forceIntercept = FALSE,
  fitBestSubset = FALSE,
  initialRidgeVariance = 10000,
  tolerance = 1e-08,
  maxIterations = 10000,
  threshold = 1e-06
)
}
\arguments{
\item{K}{Maximum # of non-zero covariates}

\item{penalty}{Specifies the IHT penalty}

\item{exclude}{A vector of numbers or covariateId names to exclude from prior}

\item{forceIntercept}{Logical: Force intercept coefficient into regularization}

\item{fitBestSubset}{Logical: Fit final subset with no regularization}

\item{initialRidgeVariance}{Numeric: variance used for algorithm initiation}

\item{tolerance}{Numeric: maximum abs change in coefficient estimates from successive iterations to achieve convergence}

\item{maxIterations}{Numeric: maximum iterations to achieve convergence}

\item{threshold}{Numeric: absolute threshold at which to force coefficient to 0}
}
\value{
An IHT Cyclops prior object of class inheriting from
\code{"cyclopsPrior"} for use with \code{fitCyclopsModel}.
}
\description{
\code{createFastIhtPrior} creates a fastIHT Cyclops prior object for use with \code{\link{fitCyclopsModel}}.
}
\examples{
nobs = 500; ncovs = 100
prior <- createFastIhtPrior(K = 3, penalty = log(ncovs), initialRidgeVariance = 1 / log(ncovs))

}
