% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-data.R
\name{irtree_recode}
\alias{irtree_recode}
\title{Recode data into pseudoitems}
\usage{
irtree_recode(object = NULL, data = NULL, keep = FALSE)
}
\arguments{
\item{object}{Object of class \code{irtree_model}. See \link{irtree_model} for more
information.}

\item{data}{Data frame containing containing one row per respondent and one
column per variable. The variable names must correspond to those used in
\code{object}.}

\item{keep}{Logical indicating whether to append the original items to the
data frame of the generated pseudoitems}
}
\value{
Data frame
}
\description{
This function takes a data set with polytomous items and an \code{irtree_model}
and returns the recoded items, the so-called pseudoitems.
}
\examples{
m1 <- "
IRT:
t BY x1;
e BY x1;
m BY x1;
Equations:
1 = (1-m)*(1-t)*e
2 = (1-m)*(1-t)*(1-e)
3 = m
4 = (1-m)*t*(1-e)
5 = (1-m)*t*e
Class:
Tree
"
model1 <- irtree_model(m1)
dat <- data.frame(x1 = 1:5)
irtree_recode(model1, dat, keep = TRUE)
}
