% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cad.R
\name{cad}
\alias{cad}
\alias{cad.default}
\alias{cad.detritals}
\alias{cad.UPb}
\alias{cad.PbPb}
\alias{cad.ArAr}
\alias{cad.KCa}
\alias{cad.ThPb}
\alias{cad.ThU}
\alias{cad.ReOs}
\alias{cad.SmNd}
\alias{cad.RbSr}
\alias{cad.LuHf}
\alias{cad.UThHe}
\alias{cad.fissiontracks}
\title{Plot continuous data as cumulative age distributions}
\usage{
cad(x, ...)

\method{cad}{default}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  hide = NULL,
  ...
)

\method{cad}{detritals}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "heat.colors",
  hide = NULL,
  ...
)

\method{cad}{UPb}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  type = 4,
  cutoff.76 = 1100,
  cutoff.disc = discfilter(),
  common.Pb = 0,
  hide = NULL,
  ...
)

\method{cad}{PbPb}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  common.Pb = 1,
  hide = NULL,
  ...
)

\method{cad}{ArAr}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = FALSE,
  hide = NULL,
  ...
)

\method{cad}{KCa}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = FALSE,
  hide = NULL,
  ...
)

\method{cad}{ThPb}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{cad}{ThU}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [ka]",
  col = "black",
  i2i = FALSE,
  detritus = 0,
  hide = NULL,
  ...
)

\method{cad}{ThPb}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{cad}{ReOs}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{cad}{SmNd}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{cad}{RbSr}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{cad}{LuHf}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{cad}{UThHe}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  hide = NULL,
  ...
)

\method{cad}{fissiontracks}(
  x,
  pch = NA,
  verticals = TRUE,
  xlab = "age [Ma]",
  col = "black",
  hide = NULL,
  ...
)
}
\arguments{
\item{x}{a numerical vector OR an object of class \code{UPb},
\code{PbPb}, \code{ThPb}, \code{ArAr}, \code{KCa},
\code{UThHe}, \code{fissiontracks}, \code{ReOs}, \code{RbSr},
\code{SmNd}, \code{LuHf}, \code{ThU} or \code{detritals}}

\item{...}{optional arguments to the generic \code{plot} function}

\item{pch}{plot character to mark the beginning of each CAD step}

\item{verticals}{logical flag indicating if the horizontal lines of
the CAD should be connected by vertical lines}

\item{xlab}{x-axis label}

\item{col}{either the name of one of \code{R}'s built-in colour
palettes (e.g., \code{'heat.colors'}, \code{'terrain.colors'},
\code{'topo.colors'}, \code{'cm.colors'}) (if \code{x} has
class \code{detritals}) OR the name or code for a colour to
give to single sample datasets.}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), the concordia age (\code{type}=5), or the
\eqn{^{208}}Pb/\eqn{^{232}}Th age (\code{type}=6).}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U-age and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{discordance cutoff filter. This is an object of
class \code{\link{discfilter}}.}

\item{common.Pb}{common lead correction:

\code{0}: none

\code{1}: use the Pb-composition stored in

\code{settings('iratio','Pb207Pb206')} (if \code{x} has class
\code{UPb} and \code{x$format<4});

\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')} (if \code{x} has class
\code{PbPb} or \code{x} has class \code{UPb} and
\code{3<x$format<7}); or

\code{settings('iratio','Pb208Pb206')} and
\code{settings('iratio','Pb208Pb207')} (if \code{x} has class
\code{UPb} and \code{x$format=7} or \code{8}).

\code{2}: use the isochron intercept as the initial Pb-composition

\code{3}: use the Stacey-Kramers two-stage model to infer the
initial Pb-composition (only applicable if \code{x} has class
\code{UPb})}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common')
\eqn{^{40}}Ar/\eqn{^{36}}Ar, \eqn{^{40}}Ca/\eqn{^{44}}Ca,
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{87}}Sr/\eqn{^{86}}Sr,
\eqn{^{143}}Nd/\eqn{^{144}}Nd, \eqn{^{187}}Os/\eqn{^{188}}Os,
\eqn{^{230}}Th/\eqn{^{232}}Th, \eqn{^{176}}Hf/\eqn{^{177}}Hf or
\eqn{^{204}}Pb/\eqn{^{208}}Pb ratio from an isochron
fit. Setting \code{i2i} to \code{FALSE} uses the default values
stored in \code{settings('iratio',...)}.}

\item{detritus}{detrital \eqn{^{230}}Th correction (only applicable
    when \code{x$format=1} or \code{2}).

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus.

\code{3}: correct the data using the measured present day
\eqn{^{230}}Th/\eqn{^{238}}U, \eqn{^{232}}Th/\eqn{^{238}}U and
\eqn{^{234}}U/\eqn{^{238}}U-ratios in the detritus.}
}
\description{
Plot a dataset as a Cumulative Age Distribution (CAD), also known
as a `empirical cumulative distribution function'.
}
\details{
Empirical cumulative distribution functions or cumulative age
distributions are the most straightforward way to visualise the
probability distribution of multiple dates.  Suppose that we have a
set of \eqn{n} dates \eqn{t_i}. The CAD is a step function that
sets out the rank order of the dates against their numerical value:

\eqn{CAD(t) = \sum_i 1(t<t_i)/n}

where 1(\eqn{\ast}) = 1 if \eqn{\ast} is true and 1(\eqn{\ast}) = 0
if \eqn{\ast} is false. CADs have two desirable properties
(Vermeesch, 2007). First, they do not require any pre-treatment or
smoothing of the data. This is not the case for histograms or
kernel density estimates. Second, it is easy to superimpose several
CADs on the same plot. This facilitates the intercomparison of
multiple samples. The interpretation of CADs is straightforward but
not very intuitive. The prominence of individual age components is
proportional to the steepness of the CAD. This is different from
probability density estimates such as histograms, in which such
components stand out as peaks.
}
\examples{
attach(examples)
cad(DZ,verticals=FALSE,pch=20)
}
\references{
Vermeesch, P., 2007. Quantitative geomorphology of the
    White Mountains (California) using detrital apatite fission
    track thermochronology. Journal of Geophysical Research: Earth
    Surface, 112(F3).
}
\seealso{
\code{\link{kde}}, \code{\link{radialplot}}
}
