% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorellipse.R
\name{get.ellipse}
\alias{get.ellipse}
\title{Get error ellipse plot coordinates}
\usage{
get.ellipse(x, y, covmat, alpha = 0.05)
}
\arguments{
\item{x}{x-coordinate (scalar) for the centre of the ellipse}

\item{y}{y-coordinate (scalar) for the centre of the ellipse}

\item{covmat}{covariance matrix of the x-y coordinates}

\item{alpha}{the probability cutoff for the error ellipses}
}
\description{
Get error ellipse plot coordinates
}
\examples{
plot(c(90,110),c(90,110),type='l')
x = 99; y = 101;
covmat <- matrix(c(1,0.9,0.9,1),nrow=2)
ell <- get.ellipse(x,y,covmat)
polygon(ell,col=rgb(0,1,0,0.5))
lines(ell)
points(x,y,pch=21,bg='black')
}

