% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_simple_slope.R
\name{plot_simple_slope}
\alias{plot_simple_slope}
\title{Simple slope plot}
\usage{
plot_simple_slope(power_data, x = NULL, facets = NULL)
}
\arguments{
\item{power_data}{Data frame of results from power_interaction(). Can accept the raw results if up to 2 parameters were varied during simulation. Any more and data should be filtered first.}

\item{x}{Optional, the x-axis of the plot. Default is the first variable after 'pwr'.}

\item{facets}{Optional, grouping variable for plot facets. Default is the second variable after 'pwr' if present.}
}
\value{
A ggplot2 object
}
\description{
Plots the simple slope min and max estimates from power_interaction().
}
\examples{
power_analysis <- power_interaction(n.iter = 10,N = seq(100,300,by=100),
r.x1.y = 0,r.x2.y = .1,r.x1x2.y = -.2,r.x1.x2 = .3,detailed_results = TRUE)
plot_simple_slope(power_analysis)
}
