% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.R
\name{InterVA5}
\alias{InterVA5}
\title{Provide InterVA5 analysis on the data input.}
\usage{
InterVA5(Input, HIV, Malaria, write = TRUE, directory = NULL,
  filename = "VA5_result", output = "classic", append = FALSE,
  groupcode = FALSE, sci = NULL, returnCheckedData = FALSE, ...)
}
\arguments{
\item{Input}{A matrix input, or data read from csv files in the same format
as required by InterVA5. Sample input is included as data(RandomVA5).}

\item{HIV}{An indicator of the level of prevalence of HIV. The input should
be one of the following: "h"(high),"l"(low), or "v"(very low).}

\item{Malaria}{An indicator of the level of prevalence of Malaria. The input
should be one of the following: "h"(high),"l"(low), or "v"(very low).}

\item{write}{A logical value indicating whether or not the output (including
errors and warnings) will be saved to file.  If the value is set to TRUE, the
user must also provide a value for the parameter "directory".}

\item{directory}{The directory to store the output from InterVA5. It should
either be an existing valid directory, or a new folder to be created. If no
path is given and the parameter for "write" is true, then the function stops
and and error message is produced.}

\item{filename}{The filename the user wish to save the output. No extension
needed. The output is in .csv format by default.}

\item{output}{"classic": The same deliminated output format as InterVA5; or
"extended": delimited output followed by full distribution of cause of
death proability.}

\item{append}{A logical value indicating whether or not the new output
should be appended to the existing file.}

\item{groupcode}{A logical value indicating whether or not the group code
will be included in the output causes.}

\item{sci}{A data frame that contains the symptom-cause-information (aka
Probbase) that InterVA uses to assign a cause of death.}

\item{returnCheckedData}{A logical indicating if the checked data (i.e.,
the data that have been modified by the consistency checks) should be returned.}

\item{...}{not used}
}
\value{
\item{ID }{ identifier from batch (input) file} \item{MALPREV
}{ selected malaria prevalence} \item{HIVPREV }{ selected HIV prevalence}
\item{PREGSTAT }{most likely pregnancy status} \item{PREGLIK }{ likelihood of
PREGSTAT} \item{PRMAT }{ likelihood of maternal death} \item{INDET
}{ indeterminate outcome} \item{CAUSE1 }{ most likely cause} \item{LIK1 }{
likelihood of 1st cause} \item{CAUSE2 }{ second likely cause} \item{LIK2 }{
likelihood of 2nd cause} \item{CAUSE3 }{ third likely cause} \item{LIK3 }{
likelihood of 3rd cause}
\item{COMCAT }{ most likely circumstance of mortality}
\item{COMNUM }{ likelihood of COMCAT}
\item{wholeprob }{ full distribution of causes of death}
}
\description{
This function implements the algorithm in the InterVA5 software.  It
produces individual cause of death (COD) and population cause-specific mortality
fractions.  The output is saved in a .csv file specified by user.
The calculation is based on the conditional and prior distribution
of 61 CODs. The function can also  save the full probability distibution
of each individual to file. All information about each individual is
saved to a va class object.
}
\details{
Be careful if the input file does not match InterVA5 input format strictly.
The function will run normally as long as the number of symptoms are
correct. Any inconsistent symptom names will be printed in console as
warning. If there is a wrong match of symptom from warning, please change 
the input to the correct order.
}
\examples{

data(RandomVA5)
# only fit first 5 observations for a quick illustration
RandomVA5 <- RandomVA5[1:5, ]

## to get easy-to-read version of causes of death make sure the column
## orders match interVA5 standard input this can be monitored by checking
## the warnings of column names

sample.output1 <- InterVA5(RandomVA5, HIV = "h", Malaria = "l", write = FALSE, 
    directory = tempdir(), filename = "VA5_result", output = "extended", append = FALSE)

\dontrun{
## to get causes of death with group code for further usage
sample.output2 <- InterVA5(RandomVA5, HIV = "h", Malaria = "l", 
    write = FALSE, directory = "VA test", filename = "VA5_result_wt_code", output = "classic", 
    append = FALSE, groupcode = TRUE)
}


}
\references{
http://www.interva.net/
}
\seealso{
\code{\link{InterVA5.plot}}
}
\author{
Jason Thomas, Zehang Li, Tyler McCormick, Sam Clark
}
\keyword{InterVA}
