% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{SimilarityMeasure}
\alias{SimilarityMeasure}
\title{A measure of similarity for the outputs of the different methods}
\usage{
SimilarityMeasure(List, nrclusters = NULL, fusionsLog = TRUE,
  weightclust = TRUE, names = NULL)
}
\arguments{
\item{List}{A list of clustering outputs to be compared. The first element
of the list will be used as the reference in \code{ReorderToReference}.}

\item{nrclusters}{The number of clusters to cut the dendrogram in. Default is NULL.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}

\item{names}{Optional. Names of the methods.}
}
\value{
A vector of similarity measures, one for each method given as input.
}
\description{
The function \code{SimilarityMeasure} computes the similarity of the
methods.  Given a list of outputs as input, the first element will be seen
as the reference.  Function \code{MatrixFunction} is called upon and the
cluster numbers are rearranged according to the reference. Per method,
\code{SimilarityMeasure} investigates which objects have the same cluster
number in reference and said method. This number is divided by the total
number of objects and used as a similarity measure.
}
\examples{

data(fingerprintMat)
data(targetMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_F,MCF7_T)
names=c("FP","TP")

MCF7_SimFandT=SimilarityMeasure(List=L,nrclusters=7,fusionsLog=TRUE,weightclust=TRUE,
names=names)


}
