% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ChooseCluster}
\alias{ChooseCluster}
\title{Interactive plot to determine DE Genes and DE features for a specific
cluster}
\usage{
ChooseCluster(Interactive = TRUE, leadCpds = NULL, clusterResult = NULL,
  colorLab = NULL, binData = NULL, contData = NULL, datanames = c("FP"),
  geneExpr = NULL, topChar = 20, topG = 20, sign = 0.05,
  nrclusters = NULL, cols = NULL, n = 1)
}
\arguments{
\item{Interactive}{Logical. Whether an interactive plot should be made. Defaults to TRUE.}

\item{leadCpds}{A list of the objects of the clusters of interest. If
Interactive=TRUE, these are determined by the mouse-click and it defaults to
NULL.}

\item{clusterResult}{The output of one of the aggregated cluster functions,
The clustering result of interest. Default is NULL.}

\item{colorLab}{The clustering result the dendrogram should be colored after
as in \code{ClusterPlot}. It is the output of one of the clustering
functions.}

\item{binData}{A list of the binary feature data matrices. These will be
evaluated with the fisher's extact test. Default is NULL.}

\item{contData}{A list of continuous data sets of the objects. These will
be evaluated with the t-test. Default is NULL.}

\item{datanames}{A vector with the names of the data matrices. Default is NULL.}

\item{geneExpr}{A gene expression matrix, may also be an ExpressionSet. The
rows should correspond with the genes. Default is NULL.}

\item{topChar}{The number of top characteristics to return. If NULL, only
the significant characteristics are saved. Default is NULL.}

\item{topG}{The number of top genes to return. If NULL, only the significant
genes are saved. Default is NULL.}

\item{sign}{The significance level. Default is 0.05.}

\item{nrclusters}{Optional. The number of clusters to cut the dendrogram in.
If NULL, the dendrogram will be plotted without colors to discern the
different clusters. Default is NULL.}

\item{cols}{The colors to use in the dendrogram. Default is NULL.}

\item{n}{The number of clusters one wants to identify by a mouse click. Default is 1.}
}
\value{
The returned value is a list with one element per cluster of
interest indicated by the prefix "Choice".  This element is again a list
with the following three elements: \item{objects}{A list with the elements
LeadCpds (the objects of interest) and OrderedCpds (all objects in the
order of the clustering result)} \item{Characteristics}{The found (top)
characteristics of the feature data} \item{Genes}{A list with the elements
TopDE (a table with information on the top genes) and AllDE (a table with
information on all genes)}
}
\description{
If desired, the function produced a dendrogram of a clustering results. One
or multiple cluster can be indicated by a mouse click. From these clusters
DE genes and characteristic features are determined. It is also possible to
provide the objects of interest without producing the plot. Note, it is required to click on the dendrogram branches, not on the objects.
#' @export ChooseCluster
}
\details{
The DE genes are determined by testing for significance of the specified
cluster versus all other objects combined. This is performed by the limma
function. The binary features are evaluated with the fisher exact test while
the continuous features are tested with the t-test. Multiplicity correction
is included.
}
\examples{

\dontrun{
data(fingerprintMat)
data(targetMat)
data(geneMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

MCF7_Interactive=ChooseCluster(Interactive=TRUE,leadCpds=NULL,clusterResult=MCF7_T,
colorLab=MCF7_F,binData=list(fingerprintMat),datanames=c("FP"),geneExpr=geneMat,
topChar = 20, topG = 20,nrclusters=7,n=1)
}
}
