% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inflect.R
\name{Inflect}
\alias{Inflect}
\title{This function analyzes raw abundance data from a Thermal Profiling experiment and calculates melt temperatures and melt shifts for each protein in the experiment.
An example line of code that could be run to test the program function is shown below.
The directory below is an example directory but should be replaced with the path that the source files are present.
This directory is also the location where the output files including pdf and Excel will be transferred once the calculations are complete.
The source files should be Excel format or xlsx and there should be two files for each replicate condition.
For example if there is one replicate, there should be one file titled Condition 1.xlsx and another file titled Control 1.xlsx. Data from the Control or vehicle will be in the Control file and data from the condition or treatment will be in the Condition file.
Each spreadsheet file should have the format where the first column header should be Accession and all of the values in this column are accession numbers for the proteins.
There should be a column then for each temperature at which the experiment was run. For example if there are 8 temperatures, there should be 8 columns after the accession column.
Each temperature column can have its own label but the values in each cell should correspond to the abundance values for each protein and at each temperature.
directory<-"/Users/folder_1/folder_2"
Temperature<-c(35,45,50,55,60,75)
Rsq<-0.95
NumSD<-2
NReps<-3
Inflect(directory,Temperature,Rsq,NumSD,NReps)}
\usage{
Inflect(directory, Temperature, Rsq, NumSD, NReps)
}
\arguments{
\item{directory}{the directory where the source data files to be analyzed are saved. This is also the location where the results will be saved.}

\item{Temperature}{the temperatures from the heat treatment procedure. An example entry Temperature<-c(25,35,39.3,50.1,55.2,60.7,74.9,90)}

\item{Rsq}{the cutoff to be used for the melt shift curve fit. An example entry would be 0.95}

\item{NumSD}{the standard deviation cutoff to be used for the calculated melt shifts. For example, if NumSD = 2, proteins with melt shifts greater than 2 standard deviations from the mean will be considered significant.}

\item{NReps}{the number of replicate experiments to be analyzed}
}
\value{
xlsx files with calculated melt shift for each protein in the experiment
}
\description{
This function analyzes raw abundance data from a Thermal Profiling experiment and calculates melt temperatures and melt shifts for each protein in the experiment.
An example line of code that could be run to test the program function is shown below.
The directory below is an example directory but should be replaced with the path that the source files are present.
This directory is also the location where the output files including pdf and Excel will be transferred once the calculations are complete.
The source files should be Excel format or xlsx and there should be two files for each replicate condition.
For example if there is one replicate, there should be one file titled Condition 1.xlsx and another file titled Control 1.xlsx. Data from the Control or vehicle will be in the Control file and data from the condition or treatment will be in the Condition file.
Each spreadsheet file should have the format where the first column header should be Accession and all of the values in this column are accession numbers for the proteins.
There should be a column then for each temperature at which the experiment was run. For example if there are 8 temperatures, there should be 8 columns after the accession column.
Each temperature column can have its own label but the values in each cell should correspond to the abundance values for each protein and at each temperature.
directory<-"/Users/folder_1/folder_2"
Temperature<-c(35,45,50,55,60,75)
Rsq<-0.95
NumSD<-2
NReps<-3
Inflect(directory,Temperature,Rsq,NumSD,NReps)
}
