% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotIncidence}
\alias{plotIncidence}
\title{Plot incidence results}
\usage{
plotIncidence(
  result,
  x = "incidence_start_date",
  ylim = c(0, NA),
  ribbon = FALSE,
  facet = NULL,
  colour = NULL,
  colour_name = NULL,
  options = list()
)
}
\arguments{
\item{result}{Incidence results}

\item{x}{Variable to plot on x axis}

\item{ylim}{Limits for the Y axis}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{colour_name}{Colour legend name}

\item{options}{a list of optional plot options}
}
\value{
A ggplot with the incidence results plotted
}
\description{
Plot incidence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
plotIncidence(inc)
}
}
