% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotPrevalence}
\alias{plotPrevalence}
\title{Plot prevalence results}
\usage{
plotPrevalence(
  result,
  x = "prevalence_start_date",
  ylim = c(0, NA),
  ribbon = TRUE,
  facet = NULL,
  colour = NULL,
  colour_name = NULL
)
}
\arguments{
\item{result}{Prevalence results}

\item{x}{Variable to plot on x axis}

\item{ylim}{Limits for the Y axis}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{colour_name}{Colour legend name}
}
\value{
A ggplot with the prevalence results plotted
}
\description{
Plot prevalence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2014-01-01"), as.Date("2018-01-01"))
)
prev <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
plotPrevalence(prev)
}
}
