% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindEstimates.R
\name{bindIncidenceEstimates}
\alias{bindIncidenceEstimates}
\title{Bind multiple incidence estimates into a single set of estimates}
\usage{
bindIncidenceEstimates(...)
}
\arguments{
\item{...}{Multiple incidence estimates, generated from \code{estimateIncidence()}}
}
\value{
Bound incidence estimates
}
\description{
Bind multiple incidence estimates into a single set of estimates
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator"
)
inc1 <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
inc2 <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
incCombined <- bindIncidenceEstimates(inc1, inc2)
}
}
