% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatherIncidencePrevalenceResults.R
\name{gatherIncidencePrevalenceResults}
\alias{gatherIncidencePrevalenceResults}
\title{Gather incidence and prevalence results}
\usage{
gatherIncidencePrevalenceResults(cdm, resultList)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{resultList}{List of incidence and prevalence results}
}
\value{
A list of up to two tibbles, one with prevalence results and one
with incidence results. Note, where multiple results sets of the same type
have been passed to the function, the analysisId variable will have been
updated
}
\description{
Gather incidence and prevalence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm$denominator <- generateDenominatorCohortSet(
  cdm = cdm,
  startDate = as.Date("2008-01-01"),
  endDate = as.Date("2018-01-01")
)
prev <- estimatePointPrevalence(
cdm = cdm,
denominatorTable = "denominator",
outcomeTable = "outcome"
)
inc <- estimateIncidence(
 cdm = cdm,
 denominatorTable = "denominator",
 outcomeTable = "outcome",
 interval = "months",
 outcomeWashout = 0
 )
 results <- gatherIncidencePrevalenceResults(cdm = cdm,
                 resultList=list(prev, inc))
}
}
