% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitfc_job.R
\name{fitfc_job}
\alias{fitfc_job}
\title{Execute a single self-contained self-contained time-series imagefusion job using FITFC}
\usage{
fitfc_job(
  input_filenames,
  input_resolutions,
  input_dates,
  pred_dates,
  pred_filenames,
  pred_area,
  winsize,
  date1,
  date3,
  n_neighbors,
  hightag,
  lowtag,
  MASKIMG_options,
  MASKRANGE_options,
  output_masks,
  use_nodata_value,
  resolution_factor,
  verbose = TRUE
)
}
\arguments{
\item{input_filenames}{A string vector containing the filenames of the input images}

\item{input_resolutions}{A string vector containing the resolution-tags (corresponding to the arguments \code{hightag} and \code{lowtag}, which are by default "high" and "low") of the input images.}

\item{input_dates}{An integer vector containing the dates of the input images.}

\item{pred_dates}{An integer vector  containing the dates for which images should be predicted.}

\item{pred_filenames}{A string vector containing the filenames for the predicted images. Must match \code{pred_dates} in length and order. Must include an extension relating to one of the \href{https://gdal.org/drivers/raster/index.html}{drivers supported by GDAL}, such as ".tif".}

\item{pred_area}{(Optional) An integer vector containing parameters in image coordinates for a bounding box which specifies the prediction area. The prediction will only be done in this area. (x_min, y_min, width, height). By default will use the entire area of the first input image.}

\item{winsize}{(Optional) Window size of the rectangle around the current pixel. Default is 51.}

\item{date1}{(Optional) Set the date of the first input image pair. By default, will use the pair with the lowest date value.}

\item{date3}{(Optional) For pseudo-doublepair mode: Set the date of the second input image pair. By default, will use the pair with the highest date value.}

\item{n_neighbors}{(Optional) The number of near pixels (including the center) to use in the filtering step (spatial filtering and residual compensation). Default is 10.}

\item{hightag}{(Optional) A string which is used in \code{input_resolutions} to describe the high-resolution images. Default is "high".}

\item{lowtag}{(Optional) A string which is used in \code{input_resolutions} to describe the low-resolution images.  Default is "low".}

\item{MASKIMG_options}{(Optional) A string containing information for a mask image (8-bit, boolean, i. e. consists of 0 and 255). "For all input images the pixel values at the locations where the mask is 0 is replaced by the mean value." Example: \code{--mask-img=some_image.png}}

\item{MASKRANGE_options}{(Optional) Specify one or more intervals for valid values. Locations with invalid values will be masked out. Ranges should be given in the format \code{'[<float>,<float>]'}, \code{'(<float>,<float>)'}, \code{'[<float>,<float>'}, or \code{'<float>,<float>]'}. There are a couple of options:' \itemize{
\item{"--mask-valid-ranges"}{ Intervals which are marked as valid. Valid ranges can excluded from invalid ranges or vice versa, depending on the order of options.}
\item{"--mask-invalid-ranges"}{ Intervals which are marked as invalid. Invalid intervals can be excluded from valid ranges or vice versa, depending on the order of options.}
\item{"--mask-high-res-valid-ranges"}{ This is the same as --mask-valid-ranges, but is applied only for the high resolution images.}
\item{"--mask-high-res-invalid-ranges"}{ This is the same as --mask-invalid-ranges, but is applied only for the high resolution images.}
\item{"--mask-low-res-valid-ranges"}{ This is the same as --mask-valid-ranges, but is applied only for the low resolution images.}
\item{"--mask-low-res-invalid-ranges"}{ This is the same as --mask-invalid-ranges, but is applied only for the low resolution images.}
}}

\item{output_masks}{(Optional) Write mask images to disk? Default is "false".}

\item{use_nodata_value}{(Optional) Use the nodata value as invalid range for masking? Default is "true".}

\item{resolution_factor}{(Optional) Scale factor with which the low resolution image has been upscaled. This will be used for cubic interpolation of the residuals. Setting it to 1 will disable it. Default: 30.}

\item{verbose}{(Optional) Print progress updates to console? Default is "true".}
}
\value{
Nothing. Output files are written to disk. The Geoinformation for the output images is adopted from the first input pair images.
}
\description{
A wrapper function for \code{execute_fitfc_job_cpp}. Intended to execute a single job, that is a number of predictions based on the same input pair(s). It ensures that all of the arguments passed are of the correct type and creates sensible defaults.
}
\details{
Executes the FITFC Algorithm. If more than one pair is given, will perform prediction for the pred dates twice, once for each of the input pairs.
}
\examples{
 
# Load required libraries
library(ImageFusion)
library(raster)
# Get filesnames of high resolution images
landsat <- list.files(
  system.file("landsat/filled",
              package = "ImageFusion"),
  ".tif",
  recursive = TRUE,
  full.names = TRUE
)

# Get filesnames of low resolution images
modis <- list.files(
  system.file("modis",
              package = "ImageFusion"),
  ".tif",
  recursive = TRUE,
  full.names = TRUE
)

#Select the first two landsat images 
landsat_sel <- landsat[1:2]
#Select some corresponding modis images
modis_sel <- modis[1:12]
# Create output directory in temporary folder
out_dir <- file.path(tempdir(),"Outputs")
if(!dir.exists(out_dir)) dir.create(out_dir, recursive = TRUE)
#Run the job, fusing two images
fitfc_job(input_filenames = c(landsat_sel,modis_sel),
          input_resolutions = c("high","high",
                                "low","low","low",
                                "low","low","low",
                                "low","low","low",
                                "low","low","low"),
          input_dates = c(68,77,68,69,70,71,72,73,74,75,76,77,78,79),
          pred_dates = c(71,79),
          pred_filenames = c(file.path(out_dir,"fitfc_71.tif"),
                             file.path(out_dir,"fitfc_79.tif"))
)
# remove the output directory
unlink(out_dir,recursive = TRUE)
}
\references{
Wang, Qunming, and Peter M. Atkinson. "Spatio-temporal fusion for daily Sentinel-2 images." Remote Sensing of Environment 204 (2018): 31-42.
}
\author{
Christof Kaufmann (C++)

Johannes Mast (R)
}
