% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storedResults.R
\docType{data}
\name{discrep}
\alias{discrep}
\title{Discrepancy maps for February 1981-2011}
\format{Object obtained from the \code{createMapping} function (see details)}
\usage{
discrep
}
\description{
The object \code{discrep} is obtained from running the \code{createMapping} function
for the month of February from 1981-2011. The predictions are from the CM2.5
Forecast-oriented Low-Ocean Resolution (FLOR) model
produced by the National Oceanic and Atmospheric Administration’s Geophysical Fluid Dynamics
Laboratory converted to a Polar Stereographic grid at a 3.5-month lead time  (Vecchi et al. 2014; Msadek et al. 2014).
 Weights for converting to a polar stereograhic grid were obtained
 from the spherical coordinate remapping and interpolation package (SCRIP) (Jones 1997).
The observations are from the monthly sea ice concentration
obtained from the National Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm. The results
are distributed by the National Snow and Ice Data Center (Comiso 2000, updated 2015).
}
\details{
The object \code{discrep} is obtained from running the \code{createMapping} function. It is a list of five objects where \code{month},
\code{startYear}, and \code{endYear} give the month, first year, and last year that were mapped. The variables \code{obsList} and \code{predList}
are lists of arrays with one 3-dimensional array for each region. The first dimension is for the year. The other two dimensions
are for the fixed points' y-coordinates, the mapped points' x-coordinates, the mapped points' y-coordinates, the length of the mapping vectors in the
x-direction, the length of the vectors in the y-direction, and the angles of the mapping vectors.
}
\examples{
data(discrep)
names(discrep)
}
\references{
Bootstrap sea ice concentration:
Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}

CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model:
Vecchi, Gabriel A., et al.
\href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical}
cyclone activity." Journal of Climate 27.21 (2014): 7994-8016.

Msadek, R., et al.
\href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
 Geophysical Research Letters 41.14 (2014): 5208-5215.

National Center for Atmospheric Research, 2017: Earth system grid at NCAR. \url{https://www.
earthsystemgrid.org/home.html}.

Jones, P.W. "A user’s guide for SCRIP: A spherical coordinate remapping and interpolation package."
Los Alamos National Laboratory, Los Alamos, NM (1997).
}
\keyword{datasets}
