% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getInitMonth}
\alias{getInitMonth}
\title{Get initialization month}
\usage{
getInitMonth(month, lag)
}
\arguments{
\item{month}{month being forecast (integer from 1 to 12)}

\item{lag}{months in advance prediction is being made (integer from 1 to 11).}
}
\value{
integer corresponding to the initialization month
}
\description{
Determine initialization month based on month being forecast and lag. Considers lags up to 11 months in advance.
}
\details{
Note that this calculation assumes that the prediction for a month is its first day. This differs from the convention used in our
paper which rounds up to the nearest full month. In practice, this may not be the case.
}
\examples{
initMonth <- getInitMonth(month = 10, lag = 4)
initMonth
}
