% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixing_matrix_igraph_function.R
\name{mixing_matrix_igraph}
\alias{mixing_matrix_igraph}
\title{Mixing Matrix}
\usage{
mixing_matrix_igraph(gs, attrname)
}
\arguments{
\item{gs}{igraph object.}

\item{attrname}{Attribute name (vertex attribute)}
}
\value{
Mixing matrix
}
\description{
This function calculates the mixing matrix for an igraph object
}
\examples{
require(igraph)
##Create random International Trade Network (igraph object)
gs<-erdos.renyi.game(50,0.05,directed = TRUE)

##Add vertex attributes
V(gs)$LETTER<-rep(LETTERS[1:5],10)

##Add vertex names
V(gs)$name<-1:vcount(gs)

##Calculate mixing matrix
mixing_matrix<-mixing_matrix_igraph(gs,"LETTER")
}
