% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNblockse_function.R
\name{ITNblock_se}
\alias{ITNblock_se}
\title{ITN Blockmodel & Structural Equivalence}
\usage{
ITNblock_se(gs)
}
\arguments{
\item{gs}{International Trade Network - igraph object}
}
\value{
List object containing block membership and structural equivalence matrix results
}
\description{
This function calculates block membership for ITN and structural equivalence between countries
}
\examples{
require(igraph)
require(sna)
require(intergraph)

##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(50,0.05,directed = TRUE)

##Add edge weights
E(ITN)$weight<-runif(ecount(ITN), 0, 1)

##Blockmodel & structural equivalence analysis
blockse<-ITNblock_se(ITN)

}
