% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGeneration.R
\name{DataGeneration}
\alias{DataGeneration}
\title{Generating artificial item response data}
\usage{
DataGeneration(
  seed = 1,
  N = 2000,
  nitem_D = NULL,
  nitem_P = NULL,
  model_D,
  model_P = "GPCM",
  latent_dist = "Mixture",
  prob = 0.5,
  d = 1.7,
  sd_ratio = 1,
  a_l = 0.8,
  a_u = 2.5,
  c_l = 0,
  c_u = 0.2,
  categ
)
}
\arguments{
\item{seed}{A numeric value that is used on random sampling.
The seed number can guarantee the replicability of the result.}

\item{N}{A numeric value. The number of examinees.}

\item{nitem_D}{A numeric value. The number of dichotomous items.}

\item{nitem_P}{A numeric value. The number of polytomous items.}

\item{model_D}{A vector of length \code{nitem_D}.
The \emph{i}th element is the probability model for the \emph{i}th dichotomous item.}

\item{model_P}{A vector of length \code{nitem_P}.
The \emph{i}th element is the probability model for the \emph{i}th polytomous item.}

\item{latent_dist}{A character string that determines the type of latent distribution.
Currently available options are \code{"beta"} (four-parameter beta distribution; \code{\link{rBeta.4P}}),
\code{"chi"} (\eqn{\chi^2} distribution; \code{\link{rchisq}}),
\code{"normal"} (standard normal distribution; \code{\link{rnorm}}),
and \code{"Mixture"} (two-component Gaussian mixture distribution; see Li (2021) for details.)}

\item{prob}{A numeric value required when \code{latent_dist = "Mixture"}.
It is a \eqn{\pi = \frac{n_1}{N}} parameter of two-component Gaussian mixture distribution, where \eqn{n_1} is the estimated number of examinees who belong to the first Gaussian component and \eqn{N} is the total number of examinees (Li, 2021).}

\item{d}{A numeric value required when \code{latent_dist = "Mixture"}.
It is a \eqn{\delta = \frac{\mu_2 - \mu_1}{\bar{\sigma}}} parameter of two-component Gaussian mixture distribution,
where \eqn{\mu_1} is the estimated mean of the first Gaussian component,
\eqn{\mu_2} is the estimated mean of the second Gaussian component,
and \eqn{\bar{\sigma} = 1} is the standard deviation of the latent distribution (Li, 2021).
Without loss of generality, \eqn{\mu_2 \ge \mu_1}, thus \eqn{\delta \ge 0}, is assumed.}

\item{sd_ratio}{A numeric value required when \code{latent_dist = "Mixture"}.
It is a \eqn{\zeta = \frac{\sigma_2}{\sigma_1}} parameter of two-component Gaussian mixture distribution, where \eqn{\sigma_1} is the estimated standard deviation of the first Gaussian component, \eqn{\sigma_2} is the estimated standard deviation of the second Gaussian component (Li, 2021).}

\item{a_l}{A numeric value. The lower bound of item discrimination parameters (\emph{a}).}

\item{a_u}{A numeric value. The upper bound of item discrimination parameters (\emph{a}).}

\item{c_l}{A numeric value. The lower bound of item guessing parameters (\emph{c}).}

\item{c_u}{A numeric value. The lower bound of item guessing parameters (\emph{c}).}

\item{categ}{A numeric vector of length \code{nitem_P}.
The \emph{i}th element equals the number of categories of the \emph{i}th polyotomous item.}
}
\value{
This function returns a \code{list} which contains several objects:
\item{theta}{A vector of ability parameters (\eqn{\theta}).}
\item{item_D}{A matrix of dichotomous item parameters.}
\item{initialitem_D}{A matrix that contains initial item parameter values for dichotomous items.}
\item{data_D}{A matrix of dichotomous item responses where rows indicate examinees and columns indicate items.}
\item{item_P}{A matrix of polytomous item parameters.}
\item{initialitem_P}{A matrix that contains initial item parameter values for polytomous items.}
\item{data_P}{A matrix of polytomous item responses where rows indicate examinees and columns indicate items.}
}
\description{
This function generates artificial item response data with users specified item types, details of item parameters, and latent distribution.
}
\examples{
# Dichotomous item responses only

Alldata <- DataGeneration(seed = 1,
                          model_D = rep(3, 10),
                          N=500,
                          nitem_D = 10,
                          nitem_P = 0,
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)

data <- Alldata$data_D
item <- Alldata$item_D
initialitem <- Alldata$initialitem_D
theta <- Alldata$theta


# Polytomous item responses only

Alldata <- DataGeneration(seed = 2,
                          N=1000,
                          nitem_D = 0,
                          nitem_P = 10,
                          categ = rep(3:7,each = 2),
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)

data <- Alldata$data_P
item <- Alldata$item_P
initialitem <- Alldata$initialitem_P
theta <- Alldata$theta


# Mixed-format items

Alldata <- DataGeneration(seed = 2,
                          model_D = rep(1:2, each=10),# 1PL model is applied to item #1~10
                                                      # and 2PL model is applied to item #11~20.
                          N=1000,
                          nitem_D = 20,
                          nitem_P = 10,
                          categ = rep(3:7,each = 2),# 3 categories for item #21-22,
                                                    # 4 categories for item #23-24,
                                                    # ...,
                                                    # and 7 categories for item #29-30.
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)

DataD <- Alldata$data_D
DataP <- Alldata$data_P
itemD <- Alldata$item_D
itemP <- Alldata$item_P
initialitemD <- Alldata$initialitem_D
initialitemP <- Alldata$initialitem_P
theta <- Alldata$theta

}
\references{
Li, S. (2021). Using a two-component normal mixture distribution as a latent distribution in estimating parameters of item response models. \emph{Journal of Educational Evaluation, 34}(4), 759-789.
}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
