% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSetList.R
\name{generate_data.CDP}
\alias{generate_data.CDP}
\title{Generate data for the cumulative difference plot.}
\usage{
generate_data.CDP(
  dsList,
  runtime_or_target_value,
  isFixedBudget,
  alpha = 0.05,
  EPSILON = 1e-80,
  nOfBootstrapSamples = 1000
)
}
\arguments{
\item{dsList}{The DataSetList object.
Note that the `cumulative_difference_plot` can only compare two algorithms
in a single problem of dimension one.}

\item{runtime_or_target_value}{The target runtime or the target value}

\item{isFixedBudget}{Should be TRUE when target runtime is used. False otherwise.}

\item{alpha}{1 minus the confidence level of the confidence band.}

\item{EPSILON}{If abs(x-y) < EPSILON, then we assume that x = y.}

\item{nOfBootstrapSamples}{The number of bootstrap samples used in the estimation.}
}
\value{
A dataframe with the data to generate the cumulative difference plot.
}
\description{
This function generates a dataframe that can be used to generate
the `cumulative_difference_plot`.
}
\examples{

dsl_sub <- subset(dsl, funcId == 1)
generate_data.CDP(dsl_sub, 15, TRUE, nOfBootstrapSamples = 10)
}
